/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.socks;

import com.google.common.net.InetAddresses;
import crimsonedgehope.minecraft.fabric.socksproxyclient.BaseUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.ProxyConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.ProxyEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.socks.SocksUtils;
import io.netty.channel.ChannelPipeline;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class SocksSelection {
    public static final Logger LOGGER = BaseUtils.getLogger("Connection");
    public static final Function<InetAddress, Supplier<List<ProxyEntry>>> supplierForMinecraft = address -> ProxyConfig::getProxyEntryForMinecraft;
    public static final Function<Supplier<class_3545<String, List<String>>>, Boolean> noProxyFilter = supplier -> {
        String input = (String)((class_3545)supplier.get()).method_15442();
        Objects.requireNonNull(input);
        List settings = (List)((class_3545)supplier.get()).method_15441();
        for (String entry : settings) {
            try {
                InetAddress inputIPObject = InetAddresses.forString((String)input);
                if (inputIPObject instanceof Inet6Address) {
                    return false;
                }
                if (entry.contains("/") && BaseUtils.isIpInCidr(inputIPObject, entry)) {
                    return true;
                }
                InetAddress entryIPObject = InetAddresses.forString((String)entry);
                if (entryIPObject instanceof Inet6Address) {
                    return false;
                }
                if (!entryIPObject.equals(inputIPObject)) continue;
                return true;
            }
            catch (Throwable e) {
                if (!("." + input).endsWith("." + entry)) continue;
                return true;
            }
        }
        return false;
    };
    public static final Function<String, Boolean> filter = input -> noProxyFilter.apply(() -> new class_3545(input, ProxyConfig.noProxyList()));

    public static void fire(InetSocketAddress remote, ChannelPipeline pipeline, Supplier<List<ProxyEntry>> supplier) {
        SocksSelection.fire(remote, pipeline, supplier, false);
    }

    public static void fire(InetSocketAddress remote, ChannelPipeline pipeline, Supplier<List<ProxyEntry>> supplier, boolean silence) {
        if (remote == null) {
            LOGGER.debug("fire: remote is null");
            return;
        }
        SocksSelection.apply(remote, supplier.get(), pipeline, silence);
    }

    private static void apply(@NonNull InetSocketAddress remote, @NonNull List<ProxyEntry> proxies, @NonNull ChannelPipeline pipeline, boolean silence) {
        if (remote == null) {
            throw new NullPointerException("remote is marked non-null but is null");
        }
        if (proxies == null) {
            throw new NullPointerException("proxies is marked non-null but is null");
        }
        if (pipeline == null) {
            throw new NullPointerException("pipeline is marked non-null but is null");
        }
        SocksUtils.applyProxyChain(pipeline, proxies);
        if (!silence) {
            SocksSelection.info(proxies, remote);
        }
    }

    private static void info(@NonNull List<ProxyEntry> proxies, @NonNull InetSocketAddress remote) {
        if (proxies == null) {
            throw new NullPointerException("proxies is marked non-null but is null");
        }
        if (remote == null) {
            throw new NullPointerException("remote is marked non-null but is null");
        }
        Objects.requireNonNull(remote.getHostString());
        if (proxies.isEmpty()) {
            LOGGER.info("[Client] -> [Remote] {}:{}", (Object)remote.getHostString(), (Object)remote.getPort());
            return;
        }
        StringBuilder builder = new StringBuilder("[Client] -> ");
        for (ProxyEntry entry : proxies) {
            builder.append(String.format("[%s] %s:%s -> ", entry.getVersion().getDescription(), ((InetSocketAddress)entry.getProxy().address()).getHostString(), ((InetSocketAddress)entry.getProxy().address()).getPort()));
        }
        builder.append(String.format("[Remote] %s:%s", remote.getHostString(), remote.getPort()));
        LOGGER.info("{}", (Object)builder);
    }

    @Generated
    private SocksSelection() {
    }
}

