/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionCloudHeightManager {
    private static final DimensionCloudHeightManager INSTANCE = new DimensionCloudHeightManager();
    private final Map<ResourceKey<DimensionType>, Integer> dimensionHeights = new HashMap<ResourceKey<DimensionType>, Integer>();

    public static DimensionCloudHeightManager getInstance() {
        return INSTANCE;
    }

    public void reload(RegistryAccess registryAccess) {
        Registry registry = registryAccess.lookupOrThrow(Registries.DIMENSION_TYPE);
        this.dimensionHeights.clear();
        for (Map.Entry entry : registry.entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            DimensionType type = (DimensionType)entry.getValue();
            type.cloudHeight().ifPresent(height -> this.dimensionHeights.put((ResourceKey<DimensionType>)key, (Integer)height));
        }
    }

    public Optional<Integer> getHeight(ResourceKey<DimensionType> typeKey) {
        return Optional.ofNullable(this.dimensionHeights.get(typeKey));
    }
}

