/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.fog;

import me.flashyreese.mods.sodiumextra.client.SodiumExtraClientMod;
import me.flashyreese.mods.sodiumextra.client.fog.FogEnvironmentExtended;
import me.flashyreese.mods.sodiumextra.client.gui.FogTypeConfig;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FogEnvironment.class})
public abstract class MixinFogEnvironment
implements FogEnvironmentExtended {
    @Override
    public void sodium_extra$applyFogSettings(FogType fogType, FogData fogData, Entity entity, BlockPos blockPos, ClientLevel level, float viewDistance, DeltaTracker deltaTracker) {
        FogTypeConfig config = SodiumExtraClientMod.options().renderSettings.fogTypeConfig.computeIfAbsent(fogType, k -> new FogTypeConfig());
        if (!SodiumExtraClientMod.options().renderSettings.globalFog || !config.enable) {
            fogData.environmentalStart = Float.MAX_VALUE;
            fogData.environmentalEnd = Float.MAX_VALUE;
            fogData.renderDistanceStart = Float.MAX_VALUE;
            fogData.renderDistanceEnd = Float.MAX_VALUE;
            fogData.skyEnd = Float.MAX_VALUE;
            fogData.cloudEnd = Float.MAX_VALUE;
            return;
        }
        float environmentStartMultiplier = (float)config.environmentStartMultiplier / 100.0f;
        float environmentEndMultiplier = (float)config.environmentEndMultiplier / 100.0f;
        float renderDistanceStartMultiplier = (float)config.renderDistanceStartMultiplier / 100.0f;
        float renderDistanceEndMultiplier = (float)config.renderDistanceEndMultiplier / 100.0f;
        float skyEndMultiplier = (float)config.skyEndMultiplier / 100.0f;
        float cloudEndMultiplier = (float)config.cloudEndMultiplier / 100.0f;
        fogData.environmentalStart *= environmentStartMultiplier;
        fogData.environmentalEnd *= environmentEndMultiplier;
        fogData.renderDistanceStart *= renderDistanceStartMultiplier;
        fogData.renderDistanceEnd *= renderDistanceEndMultiplier;
        fogData.skyEnd *= skyEndMultiplier;
        fogData.cloudEnd *= cloudEndMultiplier;
    }
}

