/*
 * Decompiled with CFR 0.152.
 */
package io.github.derec4.endToOverworld.utils;

import io.github.derec4.endToOverworld.utils.ParticleUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerUtils {
    public static void teleportToOverworld(JavaPlugin plugin, Player player, Location from) {
        World overworld = Bukkit.getWorlds().stream().filter(w -> w.getEnvironment() == World.Environment.NORMAL).findFirst().orElse(null);
        if (overworld == null) {
            plugin.getLogger().warning("No Overworld found to teleport player from End. Falling back to the first loaded world.");
            if (Bukkit.getWorlds().isEmpty()) {
                plugin.getLogger().warning("No worlds available to teleport player.");
                return;
            }
            overworld = (World)Bukkit.getWorlds().get(0);
            plugin.getLogger().info("Falling back to world: " + overworld.getName());
        }
        double x = from.getX();
        double z = from.getZ();
        int safeY = overworld.getHighestBlockYAt((int)Math.floor(x), (int)Math.floor(z)) + 1;
        Location target = new Location(overworld, x, (double)safeY, z, from.getYaw(), from.getPitch());
        ParticleUtils.playTransitionAndTeleport(plugin, player, target);
    }
}

