/*
 * Decompiled with CFR 0.152.
 */
package io.github.derec4.endToOverworld.utils;

import io.github.derec4.endToOverworld.utils.ConfigManager;
import io.github.derec4.endToOverworld.utils.ParticleUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerUtils {
    public static void teleportToOverworld(JavaPlugin plugin, Player player, Location from) {
        World overworld = null;
        String fallbackWorldName = ConfigManager.getFallbackWorld();
        if (fallbackWorldName != null && !fallbackWorldName.equalsIgnoreCase("auto") && (overworld = Bukkit.getWorld((String)fallbackWorldName)) != null) {
            plugin.getLogger().info("Using configured fallback world: " + overworld.getName());
        }
        if (overworld == null) {
            overworld = Bukkit.getWorlds().stream().filter(w -> w.getEnvironment() == World.Environment.NORMAL).findFirst().orElse(null);
        }
        if (overworld == null) {
            if (Bukkit.getWorlds().isEmpty()) {
                plugin.getLogger().warning("No worlds available to teleport player.");
                return;
            }
            overworld = (World)Bukkit.getWorlds().get(0);
        }
        double x = from.getX();
        double z = from.getZ();
        int overSpawnYPos = ConfigManager.getOverSpawnYPos();
        int safeY = overSpawnYPos <= 0 ? overworld.getHighestBlockYAt((int)Math.floor(x), (int)Math.floor(z)) + 1 : overSpawnYPos;
        Location target = new Location(overworld, x, (double)safeY, z, from.getYaw(), from.getPitch());
        ParticleUtils.playTransitionAndTeleport(plugin, player, target);
    }
}

