/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.block;

import com.mojang.serialization.MapCodec;
import net.freedinner.display.block.AbstractStackableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IngotBlock
extends AbstractStackableBlock {
    public static final MapCodec<IngotBlock> CODEC = IngotBlock.simpleCodec(IngotBlock::new);

    public IngotBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public MapCodec<IngotBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int i = this.getStacks(state);
        return switch (i) {
            case 1 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield IngotBlock.box((double)5.5, (double)0.0, (double)3.0, (double)10.5, (double)3.0, (double)13.0);
                    }
                    case EAST: 
                    case WEST: {
                        yield IngotBlock.box((double)3.0, (double)0.0, (double)5.5, (double)13.0, (double)3.0, (double)10.5);
                    }
                }
                yield IngotBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
            }
            case 2 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield IngotBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)3.0, (double)14.0);
                    }
                    case EAST: 
                    case WEST: {
                        yield IngotBlock.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)3.0, (double)15.0);
                    }
                }
                yield IngotBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
            }
            case 3, 4 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield IngotBlock.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)6.0, (double)13.0);
                    }
                    case EAST: 
                    case WEST: {
                        yield IngotBlock.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)6.0, (double)14.0);
                    }
                }
                yield IngotBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
            }
            default -> IngotBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        };
    }

    @Override
    public int getMaxStackable() {
        return 3;
    }
}

