/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.freedinner.display.client.model.ItemDisplayModel;
import net.freedinner.display.client.renderer.AbstractDisplayState;
import net.freedinner.display.client.renderer.DisplayedItemLayer;
import net.freedinner.display.entity.ItemDisplay;
import net.freedinner.display.init.DisplayModels;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class ItemDisplayRenderer
extends LivingEntityRenderer<ItemDisplay, AbstractDisplayState, ItemDisplayModel<AbstractDisplayState>> {
    public ItemDisplayRenderer(EntityRendererProvider.Context context) {
        super(context, new ItemDisplayModel(context.bakeLayer(DisplayModels.DISPLAY)), 0.0f);
        this.addLayer(new DisplayedItemLayer((RenderLayerParent<AbstractDisplayState, ItemDisplayModel<AbstractDisplayState>>)this));
    }

    public ResourceLocation getTextureLocation(AbstractDisplayState target) {
        return ResourceLocation.fromNamespaceAndPath((String)"items_displayed", (String)"textures/entity/item_display.png");
    }

    public AbstractDisplayState createRenderState() {
        return new AbstractDisplayState();
    }

    public void extractRenderState(ItemDisplay display, AbstractDisplayState state, float f1) {
        super.extractRenderState((LivingEntity)display, (LivingEntityRenderState)state, f1);
        this.itemModelResolver.updateForLiving(state.heldItem, display.getOffhandItem(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (LivingEntity)display);
        state.yRot = Mth.rotLerp((float)f1, (float)display.yRotO, (float)display.getYRot());
        state.lastHit = (float)(display.level().getGameTime() - display.lastHit) + f1;
        state.stack = display.getOffhandItem();
    }

    protected boolean shouldShowName(ItemDisplay target, double d) {
        return false;
    }

    protected void setupRotations(AbstractDisplayState target, PoseStack pose, float f1, float f2) {
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - f1));
        if (target.lastHit < 5.0f) {
            pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.sin((float)(target.lastHit / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }
}

