/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.freedinner.display.client.model.PillowModel;
import net.freedinner.display.client.renderer.AbstractDisplayState;
import net.freedinner.display.client.renderer.PillowedItemLayer;
import net.freedinner.display.entity.ItemPillow;
import net.freedinner.display.init.DisplayModels;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class PillowRenderer
extends LivingEntityRenderer<ItemPillow, AbstractDisplayState, PillowModel<AbstractDisplayState>> {
    public PillowRenderer(EntityRendererProvider.Context context) {
        super(context, new PillowModel(context.bakeLayer(DisplayModels.PILLOW)), 0.0f);
        this.addLayer(new PillowedItemLayer((RenderLayerParent<AbstractDisplayState, PillowModel<AbstractDisplayState>>)this));
    }

    public ResourceLocation getTextureLocation(AbstractDisplayState target) {
        return ResourceLocation.fromNamespaceAndPath((String)"items_displayed", (String)("textures/entity/jewelry_pillow/" + target.getType + "_jewelry_pillow.png"));
    }

    public AbstractDisplayState createRenderState() {
        return new AbstractDisplayState();
    }

    public void extractRenderState(ItemPillow display, AbstractDisplayState state, float f1) {
        super.extractRenderState((LivingEntity)display, (LivingEntityRenderState)state, f1);
        this.itemModelResolver.updateForLiving(state.heldItem, display.getOffhandItem(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (LivingEntity)display);
        state.yRot = Mth.rotLerp((float)f1, (float)display.yRotO, (float)display.getYRot());
        state.lastHit = (float)(display.level().getGameTime() - display.lastHit) + f1;
        state.stack = display.getOffhandItem();
        state.getType = display.getColor();
    }

    protected boolean shouldShowName(ItemPillow target, double d) {
        return false;
    }

    protected void setupRotations(AbstractDisplayState target, PoseStack pose, float f1, float f2) {
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - f1));
        if (target.lastHit < 5.0f) {
            pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.sin((float)(target.lastHit / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }
}

