/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.item;

import net.freedinner.display.entity.AbstractDisplayEntity;
import net.freedinner.display.init.DisplayConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractEntityItem
extends Item {
    public AbstractEntityItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPlaceContext place = new BlockPlaceContext(context);
        BlockPos pos = place.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Vec3 v = Vec3.atBottomCenterOf((Vec3i)pos);
        AABB nums = this.getType().getDimensions().makeBoundingBox(v.x(), v.y(), v.z());
        if (world.noCollision(null, nums) && world.getEntities(null, nums).isEmpty()) {
            if (world instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)world;
                AbstractDisplayEntity target = (AbstractDisplayEntity)this.getType().create(lvl, EntityType.createDefaultStackConfig((Level)lvl, (ItemStack)stack, (LivingEntity)context.getPlayer()), pos, EntitySpawnReason.SPAWN_ITEM_USE, true, true);
                if (target == null) {
                    return InteractionResult.FAIL;
                }
                float r = ((Integer)DisplayConfig.ROTATION.get()).intValue();
                float rot = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / r)) * r;
                target.snapTo(target.getX(), target.getY(), target.getZ(), rot, 0.0f);
                lvl.addFreshEntityWithPassengers((Entity)target);
                world.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                target.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
            }
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public abstract EntityType<? extends AbstractDisplayEntity> getType();
}

