/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.block;

import net.freedinner.display.block.AbstractItemBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractStackableBlock
extends AbstractItemBlock {
    public static final IntegerProperty STACKS = IntegerProperty.create((String)"stacks", (int)1, (int)4);

    public AbstractStackableBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)STACKS, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean check) {
        super.onRemove(state, world, pos, newState, check);
        if (state.getBlock() != newState.getBlock() && this.getStacks(state) > 1) {
            for (int i = 1; i < this.getStacks(state); ++i) {
                Block.popResource((Level)world, (BlockPos)pos, (ItemStack)this.getStackFor());
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STACKS});
    }

    public int getStacks(BlockState state) {
        return (Integer)state.getValue((Property)STACKS);
    }

    public BlockState getState(BlockState state) {
        return (BlockState)state.setValue((Property)STACKS, (Comparable)Integer.valueOf(this.getStacks(state) + 1));
    }

    public abstract int getMaxStackable();
}

