/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.anvianslib.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;

public abstract class Config<T> {
    protected File configFile;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    protected T config;
    private final Class<T> configClass;
    private final Logger logger;
    private String modId;

    public Config(Class<T> configClass, Logger logger) {
        this.configClass = configClass;
        this.logger = logger;
    }

    public T getConfig() {
        return this.config;
    }

    public void initialize(File configDir, String modId) {
        this.modId = modId;
        this.configFile = new File(configDir, modId + "-config.json");
        this.loadConfig();
    }

    protected abstract T createDefaultConfig();

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.config = this.createDefaultConfig();
            this.saveConfig();
        } else {
            try (FileReader reader = new FileReader(this.configFile);){
                this.config = GSON.fromJson((Reader)reader, this.configClass);
            }
            catch (IOException e) {
                this.logger.error("Failed to load config for {}", (Object)this.modId, (Object)e);
                this.config = this.createDefaultConfig();
            }
        }
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson(this.config, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.error("Failed to save config for {}", (Object)this.modId, (Object)e);
        }
    }
}

