/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.anvianslib.config;

import java.io.File;
import java.util.Optional;
import net.anvian.anvianslib.Constants;
import net.anvian.anvianslib.config.Config;
import net.anvian.anvianslib.platform.Services;
import net.anvian.anvianslib.telemetry.TelemetrySender;
import net.anvian.anvianslib.util.LibUtil;

public class TelemetryConfigManager
extends Config<TelemetryConfig> {
    private static final TelemetryConfigManager INSTANCE = new TelemetryConfigManager();
    private final TelemetrySender telemetrySender = new TelemetrySender();

    private TelemetryConfigManager() {
        super(TelemetryConfig.class, Constants.LOG);
    }

    public static TelemetryConfigManager getInstance() {
        return INSTANCE;
    }

    @Override
    protected TelemetryConfig createDefaultConfig() {
        return new TelemetryConfig();
    }

    public Optional<TelemetryConfig> getTelemetryConfig() {
        return Optional.ofNullable((TelemetryConfig)this.config);
    }

    public void sendTelemetryData(String modId, String modVersion, String gameVersion) {
        this.getTelemetryConfig().filter(TelemetryConfig::isEnableTelemetry).ifPresent(cfg -> this.telemetrySender.send(modId, modVersion, gameVersion, Services.PLATFORM.getPlatformName(), !Services.PLATFORM.isDevelopmentEnvironment()));
    }

    public void sendTelemetryData(String modId, String modVersion) {
        this.sendTelemetryData(modId, modVersion, LibUtil.getMinecraftVersion());
    }

    @Deprecated
    public void sendTelemetryDataLegacy(String modId, String modVersion, String gameVersion, String loader, boolean isProduction) {
        this.getTelemetryConfig().filter(TelemetryConfig::isEnableTelemetry).ifPresent(cfg -> this.telemetrySender.send(modId, modVersion, gameVersion, loader, isProduction));
    }

    public void initialize(File configDir) {
        super.initialize(configDir, "telemetry");
    }

    public static class TelemetryConfig {
        public boolean enableTelemetry = true;

        public boolean isEnableTelemetry() {
            return this.enableTelemetry;
        }
    }
}

