/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.anvianslib.telemetry;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.anvian.anvianslib.Constants;

public class TelemetrySender {
    private final HttpClient client = HttpClient.newHttpClient();

    public void send(String modId, String modVersion, String gameVersion, String loader, boolean isProduction) {
        URI url = isProduction ? URI.create("https://anvian.net/telemetry/data") : URI.create("http://localhost:8082/telemetry/data");
        JsonObject jsonInput = new JsonObject();
        jsonInput.addProperty("mod_id", modId);
        jsonInput.addProperty("mod_version", modVersion);
        jsonInput.addProperty("game_version", gameVersion);
        jsonInput.addProperty("loader", loader);
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(url).header("content-type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonInput.toString())).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            Constants.LOG.info("Telemetry data sent: {}", (Object)response.statusCode());
        }
        catch (IOException | InterruptedException e) {
            Constants.LOG.error("Failed to send telemetry data from {}", (Object)modId, (Object)e);
        }
    }
}

