/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosinteractiveblocks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlockActionCommand {
    private static final Map<BlockPos, File> blockActionCache = new HashMap<BlockPos, File>();

    private static String getBlockActionFileName(ServerLevel world, BlockPos pos) {
        String dimensionKey = world.dimension().location().toString().replace(":", "_");
        return dimensionKey + "_" + pos.getX() + "_" + pos.getY() + "_" + pos.getZ() + ".txt";
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        BlockActionCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blockaction").then(Commands.literal((String)"create").then(Commands.argument((String)"side", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"S", "C"}, (SuggestionsBuilder)builder)).then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"R", "L", "T", "S"}, (SuggestionsBuilder)builder)).then(Commands.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            try {
                return BlockActionCommand.createBlockAction((CommandContext<CommandSourceStack>)context);
            }
            catch (CommandSyntaxException | IOException e) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Failed to create block action: " + e.getMessage())));
                return 1;
            }
        })))))).then(Commands.literal((String)"delete").executes(context -> {
            try {
                return BlockActionCommand.deleteBlockAction((CommandContext<CommandSourceStack>)context);
            }
            catch (CommandSyntaxException | IOException e) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Failed to delete block action: " + e.getMessage())));
                return 1;
            }
        }))).then(Commands.literal((String)"info").executes(context -> {
            try {
                return BlockActionCommand.infoBlockAction((CommandContext<CommandSourceStack>)context);
            }
            catch (CommandSyntaxException | IOException e) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Failed to retrieve block action info: " + e.getMessage())));
                return 1;
            }
        })));
    }

    private static BlockPos getPlayerLookAtPos(ServerPlayer player) {
        HitResult rayTraceResult = player.pick(20.0, 0.0f, false);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            return blockHitResult.getBlockPos();
        }
        return null;
    }

    private static int createBlockAction(CommandContext<CommandSourceStack> context) throws IOException, CommandSyntaxException {
        File blockFile;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos pos = BlockActionCommand.getPlayerLookAtPos(player);
        if (pos == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You are not looking at a block!"));
            return 1;
        }
        ServerLevel world = player.level();
        String side = StringArgumentType.getString(context, (String)"side");
        String action = StringArgumentType.getString(context, (String)"action");
        String command = StringArgumentType.getString(context, (String)"command");
        File worldFolder = world.getServer().getWorldPath(LevelResource.ROOT).toFile();
        File blockActionFolder = new File(worldFolder, "BlockActions");
        if (!blockActionFolder.exists()) {
            blockActionFolder.mkdirs();
        }
        List<Object> lines = (blockFile = new File(blockActionFolder, BlockActionCommand.getBlockActionFileName(world, pos))).exists() ? Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8) : new ArrayList();
        lines.add("Side: " + side + ", Action: " + action + ", Command: " + command);
        Files.write(blockFile.toPath(), lines, new OpenOption[0]);
        player.sendSystemMessage((Component)Component.literal((String)("Block action created at X: " + pos.getX() + ", Y: " + pos.getY() + ", Z: " + pos.getZ() + ", Side: " + side + ", " + action + " with command: " + command)));
        blockActionCache.put(pos, blockFile);
        return 1;
    }

    private static int deleteBlockAction(CommandContext<CommandSourceStack> context) throws IOException, CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos pos = BlockActionCommand.getPlayerLookAtPos(player);
        if (pos == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You are not looking at a block!"));
            return 1;
        }
        ServerLevel world = player.level();
        File worldFolder = world.getServer().getWorldPath(LevelResource.ROOT).toFile();
        File blockActionFolder = new File(worldFolder, "BlockActions");
        File blockFile = new File(blockActionFolder, BlockActionCommand.getBlockActionFileName(world, pos));
        if (!blockFile.exists()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("BlockAction does not exist at " + pos.getX() + ", Y: " + pos.getY() + ", Z: " + pos.getZ() + ", ")));
            return 1;
        }
        Files.delete(blockFile.toPath());
        blockActionCache.remove(pos);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("BlockAction deleted at " + pos.getX() + ", Y: " + pos.getY() + ", Z: " + pos.getZ() + ", ")), true);
        return 1;
    }

    private static int infoBlockAction(CommandContext<CommandSourceStack> context) throws IOException, CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos pos = BlockActionCommand.getPlayerLookAtPos(player);
        if (pos == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You are not looking at a block!"));
            return 1;
        }
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        File worldFolder = world.getServer().getWorldPath(LevelResource.ROOT).toFile();
        File blockActionFolder = new File(worldFolder, "BlockActions");
        File blockFile = new File(blockActionFolder, BlockActionCommand.getBlockActionFileName(world, pos));
        if (blockFile.exists()) {
            List<String> lines = Files.readAllLines(blockFile.toPath());
            for (String line : lines) {
                String formattedLine = line.replace("Side: S", "Side: Server").replace("Side: C", "Side: Client").replace("R", "Right-click").replace("L", "Left-click").replace("S", "Redstone").replace("T", "Touch");
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)formattedLine), true);
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("BlockAction does not exist at " + pos.getX() + ", Y: " + pos.getY() + ", Z: " + pos.getZ() + ", ")));
        }
        return 1;
    }
}

