/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface SmartBrainOwner<T extends LivingEntity> {
    public List<? extends ExtendedSensor<? extends T>> getSensors();

    default public BrainActivityGroup<? extends T> getCoreTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends T> getIdleTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends T> getFightTasks() {
        return BrainActivityGroup.empty();
    }

    default public Map<Activity, BrainActivityGroup<? extends T>> getAdditionalTasks() {
        return new Object2ObjectOpenHashMap(0);
    }

    default public Set<Activity> getAlwaysRunningActivities() {
        return ImmutableSet.of((Object)Activity.CORE);
    }

    default public Activity getDefaultActivity() {
        return Activity.IDLE;
    }

    default public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{Activity.FIGHT, Activity.IDLE});
    }

    default public Set<Activity> getScheduleIgnoringActivities() {
        return ObjectArraySet.of((Object)Activity.FIGHT);
    }

    default public void handleAdditionalBrainSetup(SmartBrain<? extends T> brain) {
    }

    @Nullable
    default public SmartBrainSchedule getSchedule() {
        return null;
    }

    @ApiStatus.Internal
    default public void tickBrain(T entity) {
        entity.getBrain().tick((ServerLevel)entity.level(), entity);
    }
}

