/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class BrainActivityGroup<T extends LivingEntity> {
    private final Activity activity;
    private int priorityStart = 0;
    private final List<Behavior<? super T>> behaviours = new ObjectArrayList();
    private final Set<Pair<MemoryModuleType<?>, MemoryStatus>> activityStartMemoryConditions = new ObjectOpenHashSet();
    private Set<MemoryModuleType<?>> wipedMemoriesOnFinish = null;

    public BrainActivityGroup(Activity activity) {
        this.activity = activity;
    }

    public BrainActivityGroup<T> priority(int priorityStart) {
        this.priorityStart = priorityStart;
        return this;
    }

    public BrainActivityGroup<T> behaviours(Behavior<? super T> ... behaviours) {
        this.behaviours.addAll((Collection<Behavior<T>>)new ObjectArrayList((Object[])behaviours));
        return this;
    }

    public BrainActivityGroup<T> onlyStartWithMemoryStatus(MemoryModuleType<?> memory, MemoryStatus status) {
        this.activityStartMemoryConditions.add(Pair.of(memory, (Object)status));
        return this;
    }

    public BrainActivityGroup<T> wipeMemoriesWhenFinished(MemoryModuleType<?> ... memories) {
        if (this.wipedMemoriesOnFinish == null) {
            this.wipedMemoriesOnFinish = new ObjectOpenHashSet((Object[])memories);
        } else {
            this.wipedMemoriesOnFinish.addAll((Collection<MemoryModuleType<?>>)new ObjectOpenHashSet((Object[])memories));
        }
        return this;
    }

    public BrainActivityGroup<T> requireAndWipeMemoriesOnUse(MemoryModuleType<?> ... memories) {
        for (MemoryModuleType<?> memory : memories) {
            this.onlyStartWithMemoryStatus(memory, MemoryStatus.VALUE_PRESENT);
        }
        this.wipeMemoriesWhenFinished(memories);
        return this;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public List<Behavior<? super T>> getBehaviours() {
        return this.behaviours;
    }

    public int getPriorityStart() {
        return this.priorityStart;
    }

    public Set<Pair<MemoryModuleType<?>, MemoryStatus>> getActivityStartMemoryConditions() {
        return this.activityStartMemoryConditions;
    }

    public Set<MemoryModuleType<?>> getWipedMemoriesOnFinish() {
        return this.wipedMemoriesOnFinish != null ? this.wipedMemoriesOnFinish : Set.of();
    }

    public ImmutableList<Pair<Integer, Behavior<? super T>>> pairBehaviourPriorities() {
        int priority = this.priorityStart;
        ImmutableList.Builder pairedBehaviours = ImmutableList.builder();
        for (Behavior<? super T> behavior : this.behaviours) {
            pairedBehaviours.add((Object)Pair.of((Object)priority++, behavior));
        }
        return pairedBehaviours.build();
    }

    public static <T extends LivingEntity> BrainActivityGroup<T> empty() {
        return new BrainActivityGroup<T>(Activity.REST);
    }

    @SafeVarargs
    public static <T extends LivingEntity> BrainActivityGroup<T> coreTasks(Behavior ... behaviours) {
        return new BrainActivityGroup<T>(Activity.CORE).priority(0).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends LivingEntity> BrainActivityGroup<T> idleTasks(Behavior ... behaviours) {
        return new BrainActivityGroup<T>(Activity.IDLE).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends LivingEntity> BrainActivityGroup<T> fightTasks(Behavior ... behaviours) {
        return new BrainActivityGroup<T>(Activity.FIGHT).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(MemoryModuleType.ATTACK_TARGET);
    }
}

