/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.object.SBLShufflingList;
import org.jetbrains.annotations.Nullable;

public final class AllApplicableBehaviours<E extends LivingEntity>
extends GroupBehaviour<E> {
    @SafeVarargs
    public AllApplicableBehaviours(Pair<ExtendedBehaviour<? super E>, Integer> ... behaviours) {
        super(behaviours);
    }

    @SafeVarargs
    public AllApplicableBehaviours(ExtendedBehaviour<? super E> ... behaviours) {
        super(behaviours);
    }

    public AllApplicableBehaviours(Collection<Pair<ExtendedBehaviour<? super E>, Integer>> behaviours) {
        super(behaviours);
    }

    @Override
    @Nullable
    protected ExtendedBehaviour<? super E> pickBehaviour(ServerLevel level, E entity, long gameTime, SBLShufflingList<ExtendedBehaviour<? super E>> extendedBehaviours) {
        ExtendedBehaviour<E> lastSuccessfulBehaviour = null;
        for (ExtendedBehaviour<E> behaviour : extendedBehaviours) {
            if (!behaviour.tryStart(level, entity, gameTime)) continue;
            lastSuccessfulBehaviour = behaviour;
        }
        return lastSuccessfulBehaviour;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        boolean stillOperational = false;
        for (ExtendedBehaviour behaviour : this.behaviours) {
            stillOperational |= behaviour.getStatus() == Behavior.Status.RUNNING && behaviour.canStillUse((ServerLevel)entity.level(), entity, entity.level().getGameTime());
        }
        return stillOperational;
    }

    @Override
    protected boolean timedOut(long gameTime) {
        boolean timedOut = true;
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.getStatus() != Behavior.Status.RUNNING || behaviour.timedOut(gameTime)) continue;
            timedOut = false;
        }
        return timedOut;
    }

    @Override
    protected void tick(ServerLevel level, E owner, long gameTime) {
        boolean stillRunning = false;
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.getStatus() != Behavior.Status.RUNNING) continue;
            behaviour.tickOrStop(level, (LivingEntity)owner, gameTime);
            if (behaviour.getStatus() == Behavior.Status.STOPPED) continue;
            stillRunning = true;
        }
        if (!stillRunning) {
            this.doStop(level, (LivingEntity)owner, gameTime);
        }
    }

    @Override
    protected void stop(ServerLevel level, E entity, long gameTime) {
        this.cooldownFinishedAt = gameTime + (long)this.cooldownProvider.applyAsInt(entity);
        this.taskStopCallback.accept(entity);
        this.stop(entity);
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.getStatus() != Behavior.Status.RUNNING) continue;
            behaviour.doStop(level, (LivingEntity)entity, gameTime);
        }
    }

    @Override
    public Behavior.Status getStatus() {
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.getStatus() != Behavior.Status.RUNNING) continue;
            return Behavior.Status.RUNNING;
        }
        return Behavior.Status.STOPPED;
    }

    @Override
    public String toString() {
        Set activeBehaviours = this.behaviours.stream().filter(behaviorControl -> behaviorControl.getStatus() == Behavior.Status.RUNNING).collect(Collectors.toSet());
        return "(" + ((Object)((Object)this)).getClass().getSimpleName() + "): " + String.valueOf(activeBehaviours);
    }
}

