/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class TargetOrRetaliate<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(4).usesMemories(MemoryModuleType.ATTACK_TARGET, MemoryModuleType.HURT_BY, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    protected Predicate<LivingEntity> canAttackPredicate = entity -> {
        if (!entity.isAlive()) return false;
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (player.getAbilities().invulnerable) return false;
        return true;
    };
    protected BiPredicate<E, Entity> alertAlliesPredicate = (owner, attacker) -> false;
    protected BiPredicate<E, LivingEntity> allyPredicate = (owner, ally) -> {
        OwnableEntity pet;
        if (!owner.getClass().isAssignableFrom(ally.getClass()) || BrainUtil.getTargetOfEntity(ally) != null) {
            return false;
        }
        if (owner instanceof OwnableEntity && (pet = (OwnableEntity)owner).getOwner() != ((OwnableEntity)ally).getOwner()) {
            return false;
        }
        Entity lastHurtBy = (Entity)BrainUtil.getMemory(ally, MemoryModuleType.HURT_BY_ENTITY);
        return lastHurtBy == null || !ally.isAlliedTo(lastHurtBy);
    };
    protected boolean canSwapTarget = true;
    protected LivingEntity toTarget = null;
    protected MemoryModuleType<? extends LivingEntity> priorityTargetMemory = MemoryModuleType.NEAREST_ATTACKABLE;

    public TargetOrRetaliate<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> useMemory(MemoryModuleType<? extends LivingEntity> memory) {
        this.priorityTargetMemory = memory;
        return this;
    }

    public TargetOrRetaliate<E> alertAlliesWhen(BiPredicate<E, Entity> predicate) {
        this.alertAlliesPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> isAllyIf(BiPredicate<E, LivingEntity> predicate) {
        this.allyPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> noTargetSwapping() {
        this.canSwapTarget = false;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean doStartCheck(ServerLevel level, E entity, long gameTime) {
        return (!BrainUtil.hasMemory(entity, MemoryModuleType.ATTACK_TARGET) || this.canSwapTarget && ((Mob)entity).tickCount % 100 == 0) && super.doStartCheck(level, entity, gameTime);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        this.toTarget = this.getTarget(owner, level, BrainUtil.getTargetOfEntity(owner));
        return this.toTarget != null;
    }

    @Nullable
    protected LivingEntity getTarget(E owner, ServerLevel level, @Nullable LivingEntity existingTarget) {
        Brain brain = owner.getBrain();
        LivingEntity newTarget = BrainUtil.getMemory(brain, this.priorityTargetMemory);
        if (newTarget == null && (newTarget = (LivingEntity)BrainUtil.getMemory(brain, MemoryModuleType.HURT_BY_ENTITY)) == null) {
            NearestVisibleLivingEntities nearbyEntities = (NearestVisibleLivingEntities)BrainUtil.getMemory(brain, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
            if (nearbyEntities != null) {
                newTarget = nearbyEntities.findClosest(this.canAttackPredicate).orElse(null);
            }
            if (newTarget == null) {
                return null;
            }
        }
        if (newTarget == existingTarget) {
            return null;
        }
        return this.canAttackPredicate.test(newTarget) ? newTarget : null;
    }

    @Override
    protected void start(E entity) {
        LivingEntity existingTarget = BrainUtil.getTargetOfEntity(entity);
        BrainUtil.setTargetOfEntity(entity, this.toTarget);
        BrainUtil.clearMemory(entity, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        if (this.alertAlliesPredicate.test(entity, (Entity)this.toTarget) && existingTarget == null) {
            this.alertAllies((ServerLevel)entity.level(), entity);
        }
        this.toTarget = null;
    }

    protected void alertAllies(ServerLevel level, E owner) {
        double followRange = owner.getAttributeValue(Attributes.FOLLOW_RANGE);
        for (LivingEntity ally : EntityRetrievalUtil.getEntities(owner, followRange, 10.0, followRange, LivingEntity.class, entity -> this.allyPredicate.test(owner, (LivingEntity)entity))) {
            BrainUtil.setTargetOfEntity(ally, this.toTarget);
        }
    }
}

