/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.navigation;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.navigation.ExtendedNavigator;
import org.jetbrains.annotations.Nullable;

public class SmoothGroundNavigation
extends GroundPathNavigation
implements ExtendedNavigator {
    public SmoothGroundNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    @Override
    public Mob getMob() {
        return this.mob;
    }

    @Override
    @Nullable
    public Path getPath() {
        return super.getPath();
    }

    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, maxVisitedNodes){

            @Nullable
            public Path findPath(PathNavigationRegion navigationRegion, Mob mob, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
                Path path = super.findPath(navigationRegion, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
                return path == null ? null : new Path(path.nodes, path.getTarget(), path.canReach()){

                    public Vec3 getEntityPosAtNode(Entity entity, int nodeIndex) {
                        return SmoothGroundNavigation.this.getEntityPosAtNode(nodeIndex);
                    }
                };
            }
        };
    }

    protected void followThePath() {
        Vec3 safeSurfacePos = this.getTempMobPos();
        int shortcutNode = this.getClosestVerticalTraversal(Mth.floor((double)safeSurfacePos.y));
        float f = this.maxDistanceToWaypoint = this.mob.getBbWidth() > 0.75f ? this.mob.getBbWidth() / 2.0f : 0.75f - this.mob.getBbWidth() / 2.0f;
        if (!this.attemptShortcut(shortcutNode, safeSurfacePos) && (this.isCloseToNextNode(0.5f) || this.isAboutToTraverseVertically() && this.isCloseToNextNode(this.getMaxDistanceToWaypoint()))) {
            this.path.advance();
        }
        this.doStuckDetection(safeSurfacePos);
    }

    public int getSurfaceY() {
        return super.getSurfaceY();
    }

    protected int getClosestVerticalTraversal(int safeSurfaceHeight) {
        int nodesLength = this.path.getNodeCount();
        for (int nodeIndex = this.path.getNextNodeIndex(); nodeIndex < nodesLength; ++nodeIndex) {
            if (this.path.getNode((int)nodeIndex).y == safeSurfaceHeight) continue;
            return nodeIndex;
        }
        return nodesLength;
    }
}

