/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.navigation.nodeevaluator;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidType;
import net.tslat.smartbrainlib.api.core.navigation.MultiFluidNavigationElement;

public class MultiFluidWalkNodeEvaluator
extends WalkNodeEvaluator
implements MultiFluidNavigationElement {
    public Node getStart() {
        BlockPos.MutableBlockPos testPos;
        int groundY;
        block11: {
            groundY = this.mob.getBlockY();
            testPos = new BlockPos.MutableBlockPos(this.mob.getX(), (double)groundY, this.mob.getZ());
            BlockState groundState = this.currentContext.getBlockState((BlockPos)testPos);
            if (!this.mob.canStandOnFluid(groundState.getFluidState())) {
                if (this.canFloat() && this.mob.isInFluidType((fluidType, height) -> this.canSwimInFluid(this.mob, (FluidType)fluidType, (double)height))) {
                    while (true) {
                        if (groundState.getFluidState().isEmpty() || !this.canSwimInFluid(this.mob, groundState.getFluidState().getFluidType())) {
                            --groundY;
                            break block11;
                        }
                        groundState = this.currentContext.getBlockState((BlockPos)testPos.setY(++groundY));
                    }
                }
                if (this.mob.onGround()) {
                    groundY = Mth.floor((double)(this.mob.getY() + 0.5));
                } else {
                    testPos.setY(Mth.floor((double)(this.mob.getY() + 1.0)));
                    while (testPos.getY() > this.currentContext.level().getMinY()) {
                        groundY = testPos.getY();
                        testPos.setY(testPos.getY() - 1);
                        groundState = this.currentContext.getBlockState((BlockPos)testPos);
                        if (groundState.isAir() || groundState.isPathfindable(PathComputationType.LAND)) continue;
                        break;
                    }
                }
            } else {
                while (this.mob.canStandOnFluid(groundState.getFluidState())) {
                    groundState = this.currentContext.getBlockState((BlockPos)testPos.setY(++groundY));
                }
                --groundY;
            }
        }
        if (!this.canStartAt((BlockPos)testPos.setY(groundY))) {
            AABB entityBounds = this.mob.getBoundingBox();
            if (this.canStartAt((BlockPos)testPos.set(entityBounds.minX, (double)groundY, entityBounds.minZ)) || this.canStartAt((BlockPos)testPos.set(entityBounds.minX, (double)groundY, entityBounds.maxZ)) || this.canStartAt((BlockPos)testPos.set(entityBounds.maxX, (double)groundY, entityBounds.minZ)) || this.canStartAt((BlockPos)testPos.set(entityBounds.maxX, (double)groundY, entityBounds.maxZ))) {
                return this.getStartNode((BlockPos)testPos);
            }
        }
        return this.getStartNode((BlockPos)testPos.set(this.mob.getX(), (double)groundY, this.mob.getZ()));
    }

    protected double getFloorLevel(BlockPos pos) {
        CollisionGetter blockGetter = this.currentContext.level();
        FluidState fluidState = blockGetter.getFluidState(pos);
        return (this.canFloat() || this.isAmphibious()) && this.canSwimInFluid(this.mob, fluidState.getFluidType(), fluidState.getHeight((BlockGetter)blockGetter, pos)) ? (double)pos.getY() + 0.5 : MultiFluidWalkNodeEvaluator.getFloorLevel((BlockGetter)blockGetter, (BlockPos)pos);
    }
}

