/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtil;
import org.jetbrains.annotations.Nullable;

public abstract class EntityFilteringSensor<P, E extends LivingEntity>
extends PredicateSensor<LivingEntity, E> {
    protected abstract MemoryModuleType<P> getMemory();

    @Override
    protected abstract BiPredicate<LivingEntity, E> predicate();

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(this.getMemory());
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        BrainUtil.setMemory(entity, this.getMemory(), this.testForEntity(entity));
    }

    protected P testForEntity(E entity) {
        NearestVisibleLivingEntities matcher = (NearestVisibleLivingEntities)BrainUtil.getMemory(entity, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        if (matcher == null) {
            return null;
        }
        return this.findMatches(entity, matcher);
    }

    @Nullable
    protected abstract P findMatches(E var1, NearestVisibleLivingEntities var2);
}

