/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.attack;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtil;
import org.jetbrains.annotations.Nullable;

public class AnimatableRangedAttack<E extends LivingEntity>
extends DelayedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(2).hasMemory(MemoryModuleType.ATTACK_TARGET).noMemory(MemoryModuleType.ATTACK_COOLING_DOWN);
    protected ToIntFunction<E> attackIntervalSupplier = entity -> entity.level().getDifficulty() == Difficulty.HARD ? 20 : 40;
    protected float attackRadius;
    @Nullable
    protected LivingEntity target = null;

    public AnimatableRangedAttack(int delayTicks) {
        super(delayTicks);
        this.attackRadius(16.0f);
    }

    public AnimatableRangedAttack<E> attackInterval(ToIntFunction<E> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    public AnimatableRangedAttack<E> attackRadius(float radius) {
        this.attackRadius = radius * radius;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        this.target = BrainUtil.getTargetOfEntity(entity);
        return BrainUtil.canSee(entity, this.target) && entity.distanceToSqr((Entity)this.target) <= (double)this.attackRadius;
    }

    @Override
    protected void start(E entity) {
        entity.swing(InteractionHand.MAIN_HAND);
        BehaviorUtils.lookAtEntity(entity, (LivingEntity)this.target);
    }

    @Override
    protected void stop(E entity) {
        this.target = null;
    }

    @Override
    protected void doDelayedAction(E entity) {
        if (this.target == null) {
            return;
        }
        if (!BrainUtil.canSee(entity, this.target) || entity.distanceToSqr((Entity)this.target) > (double)this.attackRadius) {
            return;
        }
        ((RangedAttackMob)entity).performRangedAttack(this.target, 1.0f);
        BrainUtil.setForgettableMemory(entity, MemoryModuleType.ATTACK_COOLING_DOWN, Boolean.valueOf(true), this.attackIntervalSupplier.applyAsInt(entity));
    }
}

