/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.frog.Frog;
import net.tslat.smartbrainlib.api.core.sensor.EntityFilteringSensor;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtil;
import org.jetbrains.annotations.Nullable;

public class FrogSpecificSensor<E extends LivingEntity>
extends EntityFilteringSensor<LivingEntity, E> {
    @Override
    public MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.NEAREST_ATTACKABLE;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.FROG_SPECIFIC.get();
    }

    @Override
    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, entity) -> {
            if (BrainUtil.hasMemory(entity, MemoryModuleType.HAS_HUNTING_COOLDOWN)) {
                return false;
            }
            if (!Sensor.isEntityAttackable((ServerLevel)((ServerLevel)entity.level()), (LivingEntity)entity, (LivingEntity)target)) {
                return false;
            }
            if (!Frog.canEat((LivingEntity)target)) {
                return false;
            }
            if (!target.closerThan((Entity)entity, 10.0)) {
                return false;
            }
            List unreachableTargets = (List)BrainUtil.getMemory(entity, MemoryModuleType.UNREACHABLE_TONGUE_TARGETS);
            return unreachableTargets == null || !unreachableTargets.contains(target.getUUID());
        };
    }

    @Override
    @Nullable
    protected LivingEntity findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return matcher.findClosest(target -> this.predicate().test((LivingEntity)target, entity)).orElse(null);
    }
}

