/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import org.jetbrains.annotations.ApiStatus;

public abstract class ExtendedBehaviour<E extends class_1309>
extends class_4097<E> {
    protected Predicate<E> startCondition = entity -> true;
    protected Predicate<E> stopCondition = entity -> false;
    protected Consumer<E> taskStartCallback = entity -> {};
    protected Consumer<E> taskStopCallback = entity -> {};
    protected ToIntFunction<E> runtimeProvider = entity -> 60;
    protected ToIntFunction<E> cooldownProvider = entity -> 0;
    protected long cooldownFinishedAt = 0L;

    public ExtendedBehaviour() {
        super((Map)new Object2ObjectOpenHashMap());
        for (Pair<class_4140<?>, class_4141> memoryReq : this.getMemoryRequirements()) {
            this.field_19291.put((class_4140)memoryReq.getFirst(), (class_4141)memoryReq.getSecond());
        }
    }

    public final ExtendedBehaviour<E> whenStarting(Consumer<E> callback) {
        this.taskStartCallback = callback;
        return this;
    }

    public final ExtendedBehaviour<E> whenStopping(Consumer<E> callback) {
        this.taskStopCallback = callback;
        return this;
    }

    public final ExtendedBehaviour<E> runFor(ToIntFunction<E> timeProvider) {
        this.runtimeProvider = timeProvider;
        return this;
    }

    public final ExtendedBehaviour<E> runForBetween(int minTicks, int maxTicks) {
        this.runtimeProvider = entity -> entity.method_59922().method_39332(minTicks, maxTicks);
        return this;
    }

    public final ExtendedBehaviour<E> cooldownFor(ToIntFunction<E> timeProvider) {
        this.cooldownProvider = timeProvider;
        return this;
    }

    public final ExtendedBehaviour<E> cooldownForBetween(int minTicks, int maxTicks) {
        this.cooldownProvider = entity -> entity.method_59922().method_39332(minTicks, maxTicks);
        return this;
    }

    public final ExtendedBehaviour<E> startCondition(Predicate<E> predicate) {
        this.startCondition = predicate;
        return this;
    }

    public final ExtendedBehaviour<E> stopIf(Predicate<E> predicate) {
        this.stopCondition = predicate;
        return this;
    }

    public final ExtendedBehaviour<E> noTimeout() {
        return this.runFor(entity -> Integer.MAX_VALUE);
    }

    public final boolean method_18922(class_3218 level, E entity, long gameTime) {
        if (!this.doStartCheck(level, entity, gameTime)) {
            return false;
        }
        this.field_18333 = class_4097.class_4098.field_18338;
        this.field_18334 = gameTime + (long)this.runtimeProvider.applyAsInt(entity);
        this.method_18920(level, entity, gameTime);
        return true;
    }

    @ApiStatus.Internal
    protected boolean doStartCheck(class_3218 level, E entity, long gameTime) {
        return this.cooldownFinishedAt <= gameTime && this.method_19546(entity) && this.startCondition.test(entity) && this.method_18919(level, entity);
    }

    protected boolean method_18919(class_3218 level, E entity) {
        return true;
    }

    @ApiStatus.Internal
    protected void method_18920(class_3218 level, E entity, long gameTime) {
        this.taskStartCallback.accept(entity);
        this.start(entity);
    }

    protected void start(E entity) {
    }

    @ApiStatus.Internal
    protected void method_18926(class_3218 level, E entity, long gameTime) {
        this.cooldownFinishedAt = gameTime + (long)this.cooldownProvider.applyAsInt(entity);
        this.taskStopCallback.accept(entity);
        this.stop(entity);
    }

    protected void stop(E entity) {
    }

    protected boolean method_18927(class_3218 level, E entity, long gameTime) {
        return this.shouldKeepRunning(entity) && !this.stopCondition.test(entity);
    }

    protected boolean shouldKeepRunning(E entity) {
        return false;
    }

    @ApiStatus.Internal
    protected void method_18924(class_3218 level, E entity, long gameTime) {
        this.tick(entity);
    }

    protected void tick(E entity) {
    }

    protected boolean method_18915(long gameTime) {
        return super.method_18915(gameTime);
    }

    @ApiStatus.Internal
    public final boolean method_19546(E entity) {
        class_4095 brain = entity.method_18868();
        for (Pair<class_4140<?>, class_4141> memoryPair : this.getMemoryRequirements()) {
            if (brain.method_18876((class_4140)memoryPair.getFirst(), (class_4141)memoryPair.getSecond())) continue;
            return false;
        }
        return true;
    }

    protected abstract List<Pair<class_4140<?>, class_4141>> getMemoryRequirements();
}

