/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtil;
import org.apache.commons.lang3.function.TriFunction;

public class BreakBlock<E extends class_1309>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(1).hasMemory(SBLMemoryTypes.NEARBY_BLOCKS.get());
    protected TriPredicate<E, class_2338, class_2680> targetBlockPredicate = (entity, pos, state) -> state.method_26164(class_3481.field_15495);
    protected TriPredicate<E, class_2338, class_2680> stopPredicate = (entity, pos, state) -> false;
    protected TriFunction<E, class_2338, class_2680, Integer> digTimePredicate = (entity, pos, state) -> 240;
    protected class_2338 pos = null;
    protected class_2680 state = null;
    protected int timeToBreak = 0;
    protected int breakTime = 0;
    protected int breakProgress = -1;

    public BreakBlock<E> stopBreakingIf(TriPredicate<E, class_2338, class_2680> predicate) {
        this.stopPredicate = predicate;
        return this;
    }

    public BreakBlock<E> forBlocks(TriPredicate<E, class_2338, class_2680> predicate) {
        this.targetBlockPredicate = predicate;
        return this;
    }

    public BreakBlock<E> timeToBreak(TriFunction<E, class_2338, class_2680, Integer> function) {
        this.digTimePredicate = function;
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean method_18915(long gameTime) {
        return this.breakProgress < 0 && super.method_18915(gameTime);
    }

    @Override
    protected void stop(E entity) {
        entity.method_73183().method_8517(entity.method_5628(), this.pos, -1);
        this.state = null;
        this.pos = null;
        this.timeToBreak = 0;
        this.breakTime = 0;
        this.breakProgress = -1;
    }

    @Override
    protected boolean method_18919(class_3218 level, E entity) {
        for (Pair<class_2338, class_2680> pair : BrainUtil.getMemory(entity, SBLMemoryTypes.NEARBY_BLOCKS.get())) {
            if (!this.targetBlockPredicate.test(entity, (class_2338)pair.getFirst(), (class_2680)pair.getSecond())) continue;
            this.pos = (class_2338)pair.getFirst();
            this.state = (class_2680)pair.getSecond();
            this.timeToBreak = (Integer)this.digTimePredicate.apply(entity, (Object)this.pos, (Object)this.state);
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.breakTime <= this.timeToBreak && this.targetBlockPredicate.test(entity, this.pos, entity.method_73183().method_8320(this.pos)) && !this.stopPredicate.test(entity, this.pos, this.state);
    }

    @Override
    protected void tick(E entity) {
        ++this.breakTime;
        int progress = (int)((float)this.breakTime / (float)this.timeToBreak * 10.0f);
        if (progress != this.breakProgress) {
            entity.method_73183().method_8517(entity.method_5628(), this.pos, progress);
            this.breakProgress = progress;
        }
        if (this.breakTime >= this.timeToBreak) {
            entity.method_73183().method_8650(this.pos, false);
            entity.method_73183().method_20290(2001, this.pos, class_2248.method_9507((class_2680)entity.method_73183().method_8320(this.pos)));
            this.method_18925((class_3218)entity.method_73183(), (class_1309)entity, entity.method_73183().method_75260());
        }
    }
}

