/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_5532;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtil;
import org.jetbrains.annotations.Nullable;

public class Panic<E extends class_1314>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(3).hasMemory(class_4140.field_18451).usesMemories(class_4140.field_18445, class_4140.field_39408);
    protected BiPredicate<E, class_1282> shouldPanicPredicate = (entity, damageSource) -> entity.method_40071() || entity.method_5809() || damageSource.method_5529() instanceof class_1309;
    protected Function<E, Float> speedMod = entity -> Float.valueOf(1.25f);
    protected SquareRadius radius = new SquareRadius(5.0, 4.0);
    protected ToIntBiFunction<E, class_1282> panicFor = (entity, damageSource) -> entity.method_59922().method_43051(100, 120);
    protected class_243 targetPos = null;
    protected int panicEndTime = 0;

    public Panic() {
        this.noTimeout();
    }

    public Panic<E> panicIf(BiPredicate<E, class_1282> predicate) {
        this.shouldPanicPredicate = predicate;
        return this;
    }

    public Panic<E> panicFor(ToIntBiFunction<E, class_1282> function) {
        this.panicFor = function;
        return this;
    }

    public Panic<E> speedMod(Function<E, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public Panic<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public Panic<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        if (!this.shouldPanicPredicate.test(entity, (class_1282)BrainUtil.getMemory(entity, class_4140.field_18451))) {
            return false;
        }
        this.setPanicTarget(entity);
        return this.targetPos != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return ((class_1314)entity).field_6012 < this.panicEndTime;
    }

    @Override
    protected void start(E entity) {
        BrainUtil.setMemory(entity, class_4140.field_18445, new class_4142(this.targetPos, this.speedMod.apply(entity).floatValue(), 0));
        BrainUtil.setMemory(entity, class_4140.field_39408, Boolean.valueOf(true));
        this.panicEndTime = ((class_1314)entity).field_6012 + this.panicFor.applyAsInt(entity, (class_1282)BrainUtil.getMemory(entity, class_4140.field_18451));
    }

    @Override
    protected void tick(E entity) {
        if (entity.method_5942().method_6357()) {
            this.targetPos = null;
            this.setPanicTarget(entity);
            if (this.targetPos != null) {
                BrainUtil.clearMemory(entity, class_4140.field_18449);
                BrainUtil.setMemory(entity, class_4140.field_18445, new class_4142(this.targetPos, this.speedMod.apply(entity).floatValue(), 1));
            }
        }
    }

    @Override
    protected void stop(E entity) {
        this.targetPos = null;
        this.panicEndTime = 0;
        BrainUtil.setMemory(entity, class_4140.field_39408, Boolean.valueOf(false));
    }

    @Nullable
    protected class_243 findNearbyWater(E entity) {
        class_2338 pos = entity.method_24515();
        class_1937 level = entity.method_73183();
        return !level.method_8320(pos).method_26220((class_1922)level, pos).method_1110() ? null : (class_243)class_2338.method_25997((class_2338)entity.method_24515(), (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), checkPos -> level.method_8316(checkPos).method_15767(class_3486.field_15517)).map(class_243::method_24955).orElse(null);
    }

    protected void setPanicTarget(E entity) {
        if (entity.method_5809()) {
            this.targetPos = this.findNearbyWater(entity);
        }
        if (this.targetPos == null) {
            class_1297 class_12972;
            class_1282 lastDamage = (class_1282)BrainUtil.getMemory(entity, class_4140.field_18451);
            if (lastDamage != null && (class_12972 = lastDamage.method_5529()) instanceof class_1309) {
                class_1309 attacker = (class_1309)class_12972;
                this.targetPos = class_5532.method_31511(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), (class_243)attacker.method_73189());
            }
            if (this.targetPos == null) {
                this.targetPos = class_5532.method_31510(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
            }
        }
    }
}

