/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4102;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.object.ToFloatBiFunction;
import net.tslat.smartbrainlib.util.BrainUtil;

public class FollowTemptation<E extends class_1314>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(7).hasMemory(class_4140.field_28325).noMemory(class_4140.field_28326).usesMemories(class_4140.field_18446, class_4140.field_18445, class_4140.field_28327, class_4140.field_39408, class_4140.field_18448);
    protected ToFloatBiFunction<E, class_1657> speedMod = (entity, temptingPlayer) -> 1.0f;
    protected BiPredicate<E, class_1657> shouldFollow = (entity, temptingPlayer) -> !entity.method_5626((class_1297)temptingPlayer);
    protected ToFloatBiFunction<E, class_1657> closeEnoughWhen = (owner, temptingPlayer) -> 2.5f;
    protected Object2IntFunction<E> temptationCooldown = entity -> 100;

    public FollowTemptation() {
        this.noTimeout();
    }

    public FollowTemptation<E> speedMod(ToFloatBiFunction<E, class_1657> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public FollowTemptation<E> followIf(BiPredicate<E, class_1657> predicate) {
        this.shouldFollow = predicate;
        return this;
    }

    public FollowTemptation<E> closeEnoughDist(ToFloatBiFunction<E, class_1657> closeEnoughMod) {
        this.closeEnoughWhen = closeEnoughMod;
        return this;
    }

    public FollowTemptation<E> temptationCooldown(Object2IntFunction<E> cooldownFunction) {
        this.temptationCooldown = cooldownFunction;
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        return this.shouldFollow.test(entity, (class_1657)BrainUtil.getMemory(entity, class_4140.field_28325));
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtil.hasMemory(entity, class_4140.field_28325) && !BrainUtil.hasMemory(entity, class_4140.field_28326) && !BrainUtil.hasMemory(entity, class_4140.field_18448) && this.shouldFollow.test(entity, (class_1657)BrainUtil.getMemory(entity, class_4140.field_28325));
    }

    @Override
    protected void start(E entity) {
        BrainUtil.setMemory(entity, class_4140.field_28327, Boolean.valueOf(true));
    }

    @Override
    protected void tick(E entity) {
        class_1657 temptingPlayer = (class_1657)BrainUtil.getMemory(entity, class_4140.field_28325);
        float closeEnough = this.closeEnoughWhen.applyAsFloat(entity, temptingPlayer);
        BrainUtil.setMemory(entity, class_4140.field_18446, new class_4102((class_1297)temptingPlayer, true));
        if (entity.method_5858((class_1297)temptingPlayer) < (double)(closeEnough * closeEnough)) {
            BrainUtil.clearMemory(entity, class_4140.field_18445);
        } else {
            BrainUtil.setMemory(entity, class_4140.field_18445, new class_4142((class_4115)new class_4102((class_1297)temptingPlayer, false), this.speedMod.applyAsFloat(entity, temptingPlayer), (int)closeEnough));
        }
    }

    @Override
    protected void stop(E entity) {
        int cooldownTicks = (Integer)this.temptationCooldown.apply(entity);
        BrainUtil.setForgettableMemory(entity, class_4140.field_28326, Integer.valueOf(cooldownTicks), cooldownTicks);
        BrainUtil.setMemory(entity, class_4140.field_28327, Boolean.valueOf(false));
        BrainUtil.clearMemories(entity, new class_4140[]{class_4140.field_18445, class_4140.field_18446});
    }
}

