/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_5532;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtil;
import org.jetbrains.annotations.Nullable;

public class MoveToWalkTarget<E extends class_1314>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(3).hasMemory(class_4140.field_18445).noMemory(class_4140.field_18449).usesMemory(class_4140.field_19293);
    @Nullable
    protected class_11 path;
    @Nullable
    protected class_2338 lastTargetPos;
    protected float speedModifier;

    public MoveToWalkTarget() {
        this.runFor(entity -> entity.method_59922().method_43048(100) + 150);
        this.cooldownFor(entity -> entity.method_59922().method_43048(40));
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        class_4095 brain = entity.method_18868();
        class_4142 walkTarget = (class_4142)BrainUtil.getMemory(brain, class_4140.field_18445);
        if (!this.hasReachedTarget(entity, walkTarget) && this.attemptNewPath(entity, walkTarget, false)) {
            this.lastTargetPos = walkTarget.method_19094().method_18989();
            return true;
        }
        BrainUtil.clearMemory(brain, class_4140.field_18445);
        BrainUtil.clearMemory(brain, class_4140.field_19293);
        return false;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        if (this.path == null || this.lastTargetPos == null) {
            return false;
        }
        if (entity.method_5942().method_6357()) {
            return false;
        }
        class_4142 walkTarget = (class_4142)BrainUtil.getMemory(entity, class_4140.field_18445);
        return walkTarget != null && !this.hasReachedTarget(entity, walkTarget);
    }

    @Override
    protected void start(E entity) {
        this.startOnNewPath(entity);
    }

    @Override
    protected void tick(E entity) {
        class_4142 walkTarget;
        class_11 path = entity.method_5942().method_6345();
        class_4095 brain = entity.method_18868();
        if (this.path != path) {
            this.path = path;
            BrainUtil.setMemory(brain, class_4140.field_18449, path);
        }
        if (path != null && this.lastTargetPos != null && (walkTarget = (class_4142)BrainUtil.getMemory(brain, class_4140.field_18445)).method_19094().method_18989().method_10262((class_2382)this.lastTargetPos) > 4.0 && this.attemptNewPath(entity, walkTarget, this.hasReachedTarget(entity, walkTarget))) {
            this.lastTargetPos = walkTarget.method_19094().method_18989();
            this.startOnNewPath(entity);
        }
    }

    @Override
    protected void stop(E entity) {
        class_4095 brain = entity.method_18868();
        if (!entity.method_5942().method_31267() || !BrainUtil.hasMemory(brain, class_4140.field_18445) || this.hasReachedTarget(entity, (class_4142)BrainUtil.getMemory(brain, class_4140.field_18445))) {
            this.cooldownFinishedAt = 0L;
        }
        entity.method_5942().method_6340();
        BrainUtil.clearMemories(brain, class_4140.field_18445, class_4140.field_18449);
        this.path = null;
    }

    protected boolean attemptNewPath(E entity, class_4142 walkTarget, boolean reachedCurrentTarget) {
        class_4095 brain = entity.method_18868();
        class_2338 pos = walkTarget.method_19094().method_18989();
        this.path = entity.method_5942().method_6348(pos, 0);
        this.speedModifier = walkTarget.method_19095();
        if (reachedCurrentTarget) {
            BrainUtil.clearMemory(brain, class_4140.field_19293);
            return false;
        }
        if (this.path != null && this.path.method_21655()) {
            BrainUtil.clearMemory(brain, class_4140.field_19293);
        } else {
            BrainUtil.setMemory(brain, class_4140.field_19293, Long.valueOf(entity.method_73183().method_75260()));
        }
        if (this.path != null) {
            return true;
        }
        class_243 newTargetPos = class_5532.method_31512(entity, (int)10, (int)7, (class_243)class_243.method_24955((class_2382)pos), (double)1.5707963705062866);
        if (newTargetPos != null) {
            this.path = entity.method_5942().method_6352(newTargetPos.method_10216(), newTargetPos.method_10214(), newTargetPos.method_10215(), 0);
            return this.path != null;
        }
        return false;
    }

    protected boolean hasReachedTarget(E entity, class_4142 target) {
        return target.method_19094().method_18989().method_19455((class_2382)entity.method_24515()) <= target.method_19096();
    }

    protected void startOnNewPath(E entity) {
        BrainUtil.setMemory(entity, class_4140.field_18449, this.path);
        entity.method_5942().method_6334(this.path, (double)this.speedModifier);
    }
}

