/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.schedule;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.class_1309;
import net.minecraft.class_4168;
import org.jetbrains.annotations.Nullable;

public class SmartBrainSchedule {
    private final Type type;
    private final Int2ObjectArrayMap<class_4168> timeline = new Int2ObjectArrayMap(0);
    private final ListMultimap<Integer, Consumer<class_1309>> callbacks = MultimapBuilder.hashKeys((int)0).arrayListValues().build();
    private boolean sortedTimeline = true;

    public SmartBrainSchedule() {
        this(Type.DAYTIME);
    }

    public SmartBrainSchedule(Type type) {
        this.type = type;
    }

    public SmartBrainSchedule activityAt(int tick, class_4168 activity) {
        this.timeline.put(tick, (Object)activity);
        this.sortedTimeline = false;
        return this;
    }

    public SmartBrainSchedule doAt(int tick, Consumer<class_1309> callback) {
        this.callbacks.put((Object)tick, callback);
        return this;
    }

    public void scheduleTask(class_1309 brainOwner, int delay, Consumer<class_1309> task) {
        this.callbacks.put((Object)this.type.resolveDelay(brainOwner, delay), entity -> task.accept(brainOwner));
    }

    public void clearSchedule() {
        this.callbacks.clear();
        this.timeline.clear();
    }

    @Nullable
    public class_4168 tick(class_1309 brainOwner) {
        int tick = this.type.resolve(brainOwner);
        if (!this.callbacks.isEmpty()) {
            this.callbacks.get((Object)tick).forEach(consumer -> consumer.accept(brainOwner));
            if (this.type == Type.AGE) {
                this.callbacks.removeAll((Object)tick);
            }
        }
        if (!this.timeline.isEmpty()) {
            if (!this.sortedTimeline) {
                this.sortTimeline();
            }
            int index = -1;
            class_4168 activity = null;
            for (Int2ObjectMap.Entry entry : this.timeline.int2ObjectEntrySet()) {
                ++index;
                if (entry.getIntKey() >= tick) {
                    if (entry.getIntKey() != tick) break;
                    activity = (class_4168)entry.getValue();
                    break;
                }
                activity = (class_4168)entry.getValue();
            }
            if (this.type == Type.AGE && index + 1 >= this.timeline.size()) {
                this.timeline.clear();
            }
            return activity;
        }
        return null;
    }

    private void sortTimeline() {
        Int2ObjectArrayMap copy = new Int2ObjectArrayMap(this.timeline);
        int[] keys = copy.keySet().toArray(new int[0]);
        Arrays.sort(keys);
        this.timeline.clear();
        for (int key : keys) {
            this.timeline.put(key, (Object)((class_4168)copy.get(key)));
        }
        this.sortedTimeline = true;
    }

    public final class_4168 getActivityAt(int tick) {
        if (this.type == Type.AGE) {
            return class_4168.field_18595;
        }
        class_4168 activity = class_4168.field_18595;
        for (Int2ObjectMap.Entry entry : this.timeline.int2ObjectEntrySet()) {
            if (entry.getIntKey() >= tick) {
                return activity;
            }
            activity = (class_4168)entry.getValue();
        }
        return activity;
    }

    public static enum Type {
        DAYTIME(e -> (int)(e.method_73183().method_8532() % 24000L), (e, t) -> (int)((e.method_73183().method_8532() + (long)t.intValue()) % 24000L)),
        AGE(e -> e.field_6012, (e, t) -> e.field_6012 + t);

        final ToIntFunction<class_1309> tickResolver;
        final ToIntBiFunction<class_1309, Integer> delayResolver;

        private Type(ToIntFunction<class_1309> tickResolver, ToIntBiFunction<class_1309, Integer> delayResolver) {
            this.tickResolver = tickResolver;
            this.delayResolver = delayResolver;
        }

        public int resolve(class_1309 entity) {
            return this.tickResolver.applyAsInt(entity);
        }

        public int resolveDelay(class_1309 entity, int delay) {
            return this.delayResolver.applyAsInt(entity, delay);
        }
    }
}

