/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class ItemTemptingSensor<E extends class_1309>
extends ExtendedSensor<E> {
    private static final List<class_4140<?>> MEMORIES = ObjectArrayList.of((Object[])new class_4140[]{class_4140.field_28325});
    protected TriPredicate<E, class_1799, class_1657> temptPredicate = (entity, stack, player) -> false;
    protected SquareRadius radius = new SquareRadius(10.0, 10.0);

    @Override
    public List<class_4140<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public class_4149<? extends ExtendedSensor<?>> type() {
        return SBLSensors.ITEM_TEMPTING.get();
    }

    public ItemTemptingSensor<E> temptedWith(TriPredicate<E, class_1799, class_1657> predicate) {
        return this.temptPredicate((entity, stack, player) -> {
            if (player.method_7325() || !player.method_5805()) {
                return false;
            }
            return predicate.test((Object)entity, (class_1799)stack, (class_1657)player);
        });
    }

    public ItemTemptingSensor<E> temptPredicate(TriPredicate<E, class_1799, class_1657> predicate) {
        this.temptPredicate = predicate;
        return this;
    }

    public ItemTemptingSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public ItemTemptingSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected void method_19101(class_3218 level, E entity) {
        Optional<Object> player;
        List nearbyPlayers = (List)BrainUtil.getMemory(entity, class_4140.field_18443);
        Predicate<class_1657> predicate = pl -> this.temptPredicate.test(entity, pl.method_6047(), (class_1657)pl) || this.temptPredicate.test(entity, pl.method_6079(), (class_1657)pl);
        if (nearbyPlayers != null) {
            class_1657 nearestPlayer = null;
            double nearestDistance = Double.MAX_VALUE;
            for (class_1657 pl2 : nearbyPlayers) {
                double dist;
                if (!predicate.test(pl2) || !((dist = pl2.method_5858(entity)) < nearestDistance)) continue;
                nearestDistance = dist;
                nearestPlayer = pl2;
            }
            player = Optional.ofNullable(nearestPlayer);
        } else {
            player = EntityRetrievalUtil.getNearestPlayer(entity, this.radius.xzRadius(), this.radius.yRadius(), this.radius.xzRadius(), predicate);
        }
        player.ifPresentOrElse(pl -> BrainUtil.setMemory(entity, class_4140.field_28325, pl), () -> BrainUtil.clearMemory(entity, class_4140.field_28325));
    }
}

