/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.util;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiPredicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_5819;
import net.minecraft.class_6574;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RandomUtil {
    public static final EasyRandom RANDOM = new EasyRandom(class_5819.method_43050());

    public static ThreadLocalRandom getRandomInstance() {
        return ThreadLocalRandom.current();
    }

    public static boolean fiftyFifty() {
        return RANDOM.fiftyFifty();
    }

    public static boolean oneInNChance(int n) {
        return RANDOM.oneInNChance(n);
    }

    public static boolean percentChance(double percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static boolean percentChance(float percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static int randomNumberUpTo(int upperBound) {
        return RANDOM.randomNumberUpTo(upperBound);
    }

    public static float randomValueUpTo(float upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomValueUpTo(double upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomGaussianValue() {
        return RANDOM.randomGaussianValue();
    }

    public static double randomScaledGaussianValue(double scale) {
        return RANDOM.randomScaledGaussianValue(scale);
    }

    public static int randomNumberBetween(int min, int max) {
        return RANDOM.randomNumberBetween(min, max);
    }

    public static double randomValueBetween(double min, double max) {
        return RANDOM.randomValueBetween(min, max);
    }

    @SafeVarargs
    public static <T> T getRandomSelection(T ... options) {
        return RANDOM.getRandomSelection(options);
    }

    public static <T> T getRandomSelection(@NotNull List<T> options) {
        return RANDOM.getRandomSelection(options);
    }

    @NotNull
    public static class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius);
    }

    @NotNull
    public static class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, class_1937 world) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, safeSurfacePlacement, world);
    }

    @NotNull
    public static class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, class_1937 world, int tries, @Nullable BiPredicate<class_2680, class_2338> statePredicate) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, minSpreadX, minSpreadY, minSpreadZ, safeSurfacePlacement, world, tries, statePredicate);
    }

    public static final class EasyRandom
    implements class_5819 {
        private final class_5819 random;

        public EasyRandom() {
            this(class_5819.method_43047());
        }

        public EasyRandom(@NotNull class_5819 rand) {
            this.random = rand;
        }

        public class_5819 getSource() {
            return class_5819.method_43047();
        }

        public boolean fiftyFifty() {
            return this.random.method_43056();
        }

        public boolean oneInNChance(int n) {
            if (n <= 0) {
                return false;
            }
            return this.random.method_43057() < 1.0f / (float)n;
        }

        public boolean percentChance(double percentChance) {
            if (percentChance <= 0.0) {
                return false;
            }
            if (percentChance >= 1.0) {
                return true;
            }
            return this.random.method_43058() < percentChance;
        }

        public boolean percentChance(float percentChance) {
            if (percentChance <= 0.0f) {
                return false;
            }
            if (percentChance >= 1.0f) {
                return true;
            }
            return this.random.method_43058() < (double)percentChance;
        }

        public int randomNumberUpTo(int upperBound) {
            return this.random.method_43048(upperBound);
        }

        public float randomValueUpTo(float upperBound) {
            return this.random.method_43057() * upperBound;
        }

        public double randomValueUpTo(double upperBound) {
            return this.random.method_43058() * upperBound;
        }

        public double randomGaussianValue() {
            return this.random.method_43059();
        }

        public double randomScaledGaussianValue(double scale) {
            return this.random.method_43059() * scale;
        }

        public int randomNumberBetween(int min, int max) {
            return min + (int)Math.floor(this.random.method_43058() * (double)(1 + max - min));
        }

        public double randomValueBetween(double min, double max) {
            return min + this.random.method_43058() * (max - min);
        }

        public <T> T getRandomSelection(T ... options) {
            return options[this.random.method_43048(options.length)];
        }

        public <T> T getRandomSelection(@NotNull List<T> options) {
            return options.get(this.random.method_43048(options.size()));
        }

        @NotNull
        public class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, false, null);
        }

        @NotNull
        public class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, class_1937 world) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, 0, 0, 0, safeSurfacePlacement, world, 1, null);
        }

        @NotNull
        public class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, class_1937 world, int tries, @Nullable BiPredicate<class_2680, class_2338> statePredicate) {
            class_2338.class_2339 mutablePos = centerPos.method_25503();
            xRadius = Math.max(xRadius - minSpreadX, 0);
            yRadius = Math.max(yRadius - minSpreadY, 0);
            zRadius = Math.max(zRadius - minSpreadZ, 0);
            for (int i = 0; i < tries; ++i) {
                double xAdjust = this.randomValueBetween(-xRadius, xRadius);
                double yAdjust = this.randomValueBetween(-yRadius, yRadius);
                double zAdjust = this.randomValueBetween(-zRadius, zRadius);
                int newX = (int)Math.floor((double)centerPos.method_10263() + xAdjust + (double)minSpreadX * Math.signum(xAdjust));
                int newY = (int)Math.floor((double)centerPos.method_10264() + yAdjust + (double)minSpreadY * Math.signum(yAdjust));
                int newZ = (int)Math.floor((double)centerPos.method_10260() + zAdjust + (double)minSpreadZ * Math.signum(zAdjust));
                mutablePos.method_10103(newX, newY, newZ);
                if (safeSurfacePlacement && world != null) {
                    mutablePos.method_10101((class_2382)world.method_8598(class_2902.class_2903.field_13203, (class_2338)mutablePos));
                }
                if (statePredicate != null && !statePredicate.test(world.method_8320((class_2338)mutablePos), mutablePos.method_10062())) continue;
                return mutablePos.method_10062();
            }
            return centerPos;
        }

        public EasyRandom fork() {
            return new EasyRandom(this.random.method_38420());
        }

        public class_6574 method_38421() {
            return this.random.method_38421();
        }

        public void method_43052(long seed) {
            this.random.method_43052(seed);
        }

        public int method_43054() {
            return this.random.method_43054();
        }

        public int method_43048(int upperLimit) {
            return this.random.method_43048(upperLimit);
        }

        public long method_43055() {
            return this.random.method_43055();
        }

        public boolean method_43056() {
            return this.random.method_43056();
        }

        public float method_43057() {
            return this.random.method_43057();
        }

        public double method_43058() {
            return this.random.method_43058();
        }

        public double method_43059() {
            return this.random.method_43059();
        }
    }
}

