/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.attack;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.util.BrainUtil;

public class BowAttack<E extends LivingEntity>
extends AnimatableRangedAttack<E> {
    public BowAttack(int delayTicks) {
        super(delayTicks);
    }

    @Override
    protected void start(E entity) {
        BehaviorUtils.lookAtEntity(entity, (LivingEntity)this.target);
        entity.startUsingItem(ProjectileUtil.getWeaponHoldingHand(entity, (Item)Items.BOW));
    }

    @Override
    protected void doDelayedAction(E entity) {
        if (this.target == null) {
            return;
        }
        if (!BrainUtil.canSee(entity, this.target) || entity.distanceToSqr((Entity)this.target) > (double)this.attackRadius) {
            return;
        }
        ((RangedAttackMob)entity).performRangedAttack(this.target, BowItem.getPowerForTime((int)entity.getTicksUsingItem()));
        entity.stopUsingItem();
        BrainUtil.setForgettableMemory(entity, MemoryModuleType.ATTACK_COOLING_DOWN, Boolean.valueOf(true), this.attackIntervalSupplier.applyAsInt(entity));
    }

    @Override
    protected void stop(E entity) {
        super.stop(entity);
        entity.stopUsingItem();
    }
}

