/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.look;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtil;

public class LookAtTarget<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(1).hasMemory(MemoryModuleType.LOOK_TARGET);

    public LookAtTarget() {
        this.noTimeout();
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return this.testAndInvalidateLookTarget(entity);
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.testAndInvalidateLookTarget(entity);
    }

    @Override
    protected void tick(E entity) {
        BrainUtil.withMemory(entity, MemoryModuleType.LOOK_TARGET, target -> entity.getLookControl().setLookAt(target.currentPosition()));
    }

    protected boolean testAndInvalidateLookTarget(E entity) {
        EntityTracker entityTracker;
        PositionTracker lookTarget = (PositionTracker)BrainUtil.getMemory(entity, MemoryModuleType.LOOK_TARGET);
        if (lookTarget == null) {
            return false;
        }
        if (lookTarget instanceof EntityTracker && (!(entityTracker = (EntityTracker)lookTarget).getEntity().isAlive() || entityTracker.getEntity().isSpectator())) {
            BrainUtil.clearMemory(entity, MemoryModuleType.LOOK_TARGET);
            return false;
        }
        return true;
    }
}

