/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class ItemTemptingSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.TEMPTING_PLAYER});
    protected TriPredicate<E, ItemStack, Player> temptPredicate = (entity, stack, player) -> false;
    protected SquareRadius radius = new SquareRadius(10.0, 10.0);

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.ITEM_TEMPTING.get();
    }

    public ItemTemptingSensor<E> temptedWith(TriPredicate<E, ItemStack, Player> predicate) {
        return this.temptPredicate((entity, stack, player) -> {
            if (player.isSpectator() || !player.isAlive()) {
                return false;
            }
            return predicate.test((Object)entity, (ItemStack)stack, (Player)player);
        });
    }

    public ItemTemptingSensor<E> temptPredicate(TriPredicate<E, ItemStack, Player> predicate) {
        this.temptPredicate = predicate;
        return this;
    }

    public ItemTemptingSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public ItemTemptingSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        Optional<Object> player;
        List nearbyPlayers = (List)BrainUtil.getMemory(entity, MemoryModuleType.NEAREST_PLAYERS);
        Predicate<Player> predicate = pl -> this.temptPredicate.test(entity, pl.getMainHandItem(), (Player)pl) || this.temptPredicate.test(entity, pl.getOffhandItem(), (Player)pl);
        if (nearbyPlayers != null) {
            Player nearestPlayer = null;
            double nearestDistance = Double.MAX_VALUE;
            for (Player pl2 : nearbyPlayers) {
                double dist;
                if (!predicate.test(pl2) || !((dist = pl2.distanceToSqr(entity)) < nearestDistance)) continue;
                nearestDistance = dist;
                nearestPlayer = pl2;
            }
            player = Optional.ofNullable(nearestPlayer);
        } else {
            player = EntityRetrievalUtil.getNearestPlayer(entity, this.radius.xzRadius(), this.radius.yRadius(), this.radius.xzRadius(), predicate);
        }
        player.ifPresentOrElse(pl -> BrainUtil.setMemory(entity, MemoryModuleType.TEMPTING_PLAYER, pl), () -> BrainUtil.clearMemory(entity, MemoryModuleType.TEMPTING_PLAYER));
    }
}

