/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.eventlisteners;

import com.eidng3lz.mininginplace.MiningInPlace;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="mininginplace")
public class OnBlockDrops {
    @SubscribeEvent
    public static void moveAndPushItemEntities(BlockDropsEvent event) {
        double FORCE = 0.1;
        double BLOCK_SIZE = 1.0;
        double ITEM_ENTITY_SIZE = 0.25;
        Vec3 ITEM_INITIAL_VELOCITY = new Vec3(0.0, 0.1, 0.0);
        boolean USE_NEW_OFFSET_ALGORITHM = true;
        Entity breakerEntity = event.getBreaker();
        List dropItemEntityList = event.getDrops();
        BlockPos eventPos = event.getPos();
        if (breakerEntity != null && MiningInPlace.blockBreakEventFlag.containsKey(breakerEntity.toString())) {
            Vec3 relativelyVec = eventPos.getCenter().vectorTo(breakerEntity.getEyePosition());
            Vec3 moveToVec = eventPos.getCenter();
            int result0 = OnBlockDrops.getIntersection(breakerEntity.getEyePosition(), breakerEntity.getViewVector(1.0f), new Vec3((double)eventPos.getX(), (double)eventPos.getY(), (double)eventPos.getZ()));
            double offset = 0.625;
            moveToVec = switch (result0) {
                case 0 -> eventPos.getCenter().add(-offset, 0.0, 0.0);
                case 1 -> eventPos.getCenter().add(0.0, -offset, 0.0);
                case 2 -> eventPos.getCenter().add(0.0, 0.0, -offset);
                case 3 -> eventPos.getCenter().add(offset, 0.0, 0.0);
                case 4 -> eventPos.getCenter().add(0.0, offset, 0.0);
                case 5 -> eventPos.getCenter().add(0.0, 0.0, offset);
                default -> moveToVec;
            };
            moveToVec = moveToVec.add(0.0, -0.125, 0.0);
            Vec3 pushVec = moveToVec.vectorTo(breakerEntity.getEyePosition()).multiply(0.1, 0.1, 0.1);
            for (ItemEntity item : dropItemEntityList) {
                item.setDeltaMovement(ITEM_INITIAL_VELOCITY);
                item.setPos(moveToVec);
                item.push(pushVec);
            }
            MiningInPlace.blockBreakEventFlag.remove(breakerEntity.toString());
        }
    }

    @NotNull
    private static Vec3 getOffsetVec(Vec3 relativelyVec, double BLOCK_SIZE, double ITEM_ENTITY_SIZE) {
        double max = Math.max(Math.max(Math.abs(relativelyVec.x()), Math.abs(relativelyVec.y())), Math.abs(relativelyVec.z()));
        double zoomMultiplier = (BLOCK_SIZE + ITEM_ENTITY_SIZE) / 2.0 / max;
        return relativelyVec.multiply(zoomMultiplier, zoomMultiplier, zoomMultiplier);
    }

    private static int getIntersection(Vec3 startPos, Vec3 direction, Vec3 aabbMinPos) {
        double[] startPosArr = new double[]{startPos.x(), startPos.y(), startPos.z()};
        double[] directionArr = new double[]{direction.x(), direction.y(), direction.z()};
        double[] aabbMinPosArr = new double[]{aabbMinPos.x(), aabbMinPos.y(), aabbMinPos.z()};
        double[] aabbMaxPosArr = new double[]{aabbMinPos.x() + 1.0, aabbMinPos.y() + 1.0, aabbMinPos.z() + 1.0};
        double tNear = Double.NEGATIVE_INFINITY;
        int faceIndex = -1;
        for (int i = 0; i < 3; ++i) {
            double tMin;
            int intersectIn;
            if (directionArr[i] == 0.0) continue;
            double invDir = 1.0 / directionArr[i];
            double t1 = (aabbMinPosArr[i] - startPosArr[i]) * invDir;
            double t2 = (aabbMaxPosArr[i] - startPosArr[i]) * invDir;
            if (t1 < t2) {
                intersectIn = -1;
                tMin = t1;
            } else {
                intersectIn = 1;
                tMin = t2;
            }
            if (!(tMin > tNear)) continue;
            tNear = tMin;
            if (intersectIn == -1) {
                faceIndex = i;
                continue;
            }
            if (intersectIn != 1) continue;
            faceIndex = i + 3;
        }
        return faceIndex;
    }
}

