/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.network;

import com.eidng3lz.mininginplace.Config;
import com.eidng3lz.mininginplace.MiningInPlace;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class Packets {

    public record RequestPacket(String request, String args) implements CustomPacketPayload
    {
        public static final String GET_CLIENT_CONFIGS = "get-client-configs";
        public static final String SET_CLIENT_CONFIGS = "set-client-configs";
        public static final CustomPacketPayload.Type<RequestPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mininginplace", (String)"request_packet"));
        public static final StreamCodec<ByteBuf, RequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, RequestPacket::request, (StreamCodec)ByteBufCodecs.STRING_UTF8, RequestPacket::args, RequestPacket::new);

        public static void onClientHandleDate(RequestPacket packet, IPayloadContext context) {
            switch (packet.request()) {
                case "get-client-configs": {
                    PacketDistributor.sendToServer((CustomPacketPayload)new RequestPacket(SET_CLIENT_CONFIGS, Config.getClientConfigsToJSON()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                case "set-client-configs": {
                    LogUtils.getLogger().info("client side not supported");
                    break;
                }
            }
        }

        public static void onServerHandleDate(RequestPacket packet, IPayloadContext context) {
            switch (packet.request()) {
                case "get-client-configs": {
                    LogUtils.getLogger().info("server side not supported");
                    break;
                }
                case "set-client-configs": {
                    Map map = (Map)MiningInPlace.gson.fromJson(packet.args(), (TypeToken)new TypeToken<Map<Config.ClientConfigs, Object>>(){});
                    MiningInPlace.playerConfigs.put(context.player().getName().getString(), map);
                    break;
                }
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

