/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace;

import com.eidng3lz.mininginplace.MiningInPlace;
import com.eidng3lz.mininginplace.network.Packets;
import com.eidng3lz.mininginplace.util.BlockGroup;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="mininginplace", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue INVENT_CONTROL = BUILDER.comment(new String[]{"\u53cd\u8f6c\u6f5c\u884c\u8fde\u9501\u63a7\u5236", "\u5ba2\u6237\u7aef\u914d\u7f6e", "\u9ed8\u8ba4\u6f5c\u884c\u65f6\u505c\u6b62\u8fde\u9501\u3002", "Invent control", "Client configuration", "By default, function stops while sneaking"}).translation("mininginplace.config.invent_control").define("invent_control", false);
    private static final ModConfigSpec.BooleanValue DISABLE_AT_CREATIVE = BUILDER.comment(new String[]{"\u521b\u9020\u6a21\u5f0f\u4e0b\u7981\u7528", "\u5ba2\u6237\u7aef\u914d\u7f6e", "Disable at creative", "Client configuration"}).translation("mininginplace.config.disable_at_creative").define("disable_at_creative", true);
    private static final ModConfigSpec.IntValue DEPTH_LIMIT = BUILDER.comment(new String[]{"\u6700\u5927\u641c\u7d22\u6df1\u5ea6", "\u670d\u52a1\u7aef\u914d\u7f6e", "\u8bf7\u52ff\u8bbe\u7f6e\u8fc7\u5927\u7684\u6570\u503c\uff0c\u4ee5\u514d\u51fa\u73b0\u6027\u80fd\u95ee\u9898\u3002", "Maximum search depth", "Server-side configuration", "Do not set too large a number to avoid performance issues."}).translation("mininginplace.config.depth_limit").defineInRange("depth_limit", 256, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue SEARCH_STEPS_LIMIT = BUILDER.comment(new String[]{"\u6700\u5927\u641c\u7d22\u6b65\u6570", "\u670d\u52a1\u7aef\u914d\u7f6e", "\u8bf7\u52ff\u8bbe\u7f6e\u8fc7\u5927\u7684\u6570\u503c\uff0c\u4ee5\u514d\u51fa\u73b0\u6027\u80fd\u95ee\u9898\u3002", "Search steps limit", "Server-side configuration", "Do not set too large a number to avoid performance issues."}).translation("mininginplace.config.search_steps_limit").defineInRange("search_steps_limit", 1024, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> CHAINED_BLOCKS_GROUPS = BUILDER.comment(new String[]{"\u8fde\u9501\u65b9\u5757\u7ec4", "\u670d\u52a1\u7aef\u914d\u7f6e", "\u6bcf\u4e2a\u5b57\u7b26\u4e32\u4e3a\u4e00\u7ec4\uff0c\u7ec4\u5185\u7684\u591a\u4e2aID\u6216Tag\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694\uff0cTag\u9700\u8981\u4ee5#\u5f00\u5934\u3002", "\u547d\u540d\u7a7a\u95f4\u4e3aminecraft\u65f6\u547d\u540d\u7a7a\u95f4\u53ef\u7701\u7565\u3002", "Chained blocks groups", "Server-side configuration", "Each string is a group, separated by a comma between multiple IDs or Tags in the group, and the Tags need to start with #.", "If the namespace is minecraft, the namespace can be omitted."}).translation("mininginplace.config.blocks_groups").defineListAllowEmpty("chained_blocks_groups", List.of("minecraft:oak_log", "minecraft:spruce_log", "minecraft:birch_log", "minecraft:jungle_log", "minecraft:acacia_log", "minecraft:dark_oak_log", "minecraft:mangrove_log", "minecraft:cherry_log", "minecraft:pale_oak_log", "minecraft:crimson_stem", "minecraft:warped_stem", "#minecraft:coal_ores", "#minecraft:iron_ores,minecraft:raw_iron_block", "#minecraft:copper_ores,minecraft:raw_copper_block", "#minecraft:gold_ores", "#minecraft:redstone_ores", "#minecraft:emerald_ores", "#minecraft:lapis_ores", "#minecraft:diamond_ores", "minecraft:nether_gold_ore", "minecraft:nether_quartz_ore", "minecraft:ancient_debris", "minecraft:glowstone"), () -> "", Config::validateBlockGroups);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean inventControl;
    public static boolean disableAtCreative;
    public static int depthLimit;
    public static int searchStepsLimit;
    public static List<BlockGroup> chainedBlocksGroups;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        inventControl = (Boolean)INVENT_CONTROL.get();
        disableAtCreative = (Boolean)DISABLE_AT_CREATIVE.get();
        depthLimit = (Integer)DEPTH_LIMIT.get();
        searchStepsLimit = (Integer)SEARCH_STEPS_LIMIT.get();
        chainedBlocksGroups = Config.decodeChainedBlocksGroups((List)CHAINED_BLOCKS_GROUPS.get());
        if (FMLEnvironment.dist.isClient()) {
            try {
                PacketDistributor.sendToServer((CustomPacketPayload)new Packets.RequestPacket("set-client-configs", Config.getClientConfigsToJSON()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (!FMLEnvironment.dist.isClient()) {
            try {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new Packets.RequestPacket("set-server-configs", Config.getServerConfigsToJSON()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static boolean validateBlockGroups(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String group = (String)obj;
        for (String blockIDOrTag : group.split(",")) {
            if ((blockIDOrTag = blockIDOrTag.trim()).isEmpty()) continue;
            if (blockIDOrTag.charAt(0) == '#') {
                if (blockIDOrTag.matches("^#([a-zA-Z0-9._-]+:)?[a-zA-Z0-9._-]+(/?[a-zA-Z0-9._-]+)*$")) continue;
                return false;
            }
            try {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)blockIDOrTag);
                if (BuiltInRegistries.BLOCK.containsKey(resourceLocation)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static List<BlockGroup> decodeChainedBlocksGroups(List<? extends String> stringList) {
        ArrayList<BlockGroup> blocksGroups = new ArrayList<BlockGroup>();
        for (String string : stringList) {
            ArrayList<String> blockIDOrTagList = new ArrayList<String>();
            String[] splitGroup = string.split(",");
            BlockGroup blockGroup = new BlockGroup();
            for (String s : splitGroup) {
                String blockIDOrTag = s.trim();
                if (blockIDOrTag.isEmpty()) continue;
                blockIDOrTagList.add(blockIDOrTag);
            }
            for (String s : blockIDOrTagList) {
                blockGroup.addFromStr(s);
            }
            blocksGroups.add(blockGroup);
        }
        return blocksGroups;
    }

    public static String getClientConfigsToJSON() {
        HashMap map = new HashMap();
        for (ClientConfigs clientConfig : ClientConfigs.values()) {
            map.put(clientConfig, clientConfig.getConfig().get());
        }
        Type type = new TypeToken<Map<ClientConfigs, Object>>(){}.getType();
        String json = MiningInPlace.gson.toJson(map, type);
        return json;
    }

    public static String getServerConfigsToJSON() {
        HashMap map = new HashMap();
        for (ServerConfigs serverConfig : ServerConfigs.values()) {
            map.put(serverConfig, serverConfig.getConfig().get());
        }
        Type type = new TypeToken<Map<ServerConfigs, Object>>(){}.getType();
        String json = MiningInPlace.gson.toJson(map, type);
        return json;
    }

    public static enum ClientConfigs {
        INVENT_CONTROL((Supplier<?>)INVENT_CONTROL),
        DISABLE_AT_CREATIVE((Supplier<?>)DISABLE_AT_CREATIVE);

        private final Supplier<?> config;

        private ClientConfigs(Supplier<?> config) {
            this.config = config;
        }

        public Supplier<?> getConfig() {
            return this.config;
        }
    }

    public static enum ServerConfigs {
        DEPTH_LIMIT((Supplier<?>)DEPTH_LIMIT),
        SEARCH_STEPS_LIMIT((Supplier<?>)SEARCH_STEPS_LIMIT),
        CHAINED_BLOCKS_GROUPS((Supplier<?>)CHAINED_BLOCKS_GROUPS);

        private final Supplier<?> config;

        private ServerConfigs(Supplier<?> config) {
            this.config = config;
        }

        public Supplier<?> getConfig() {
            return this.config;
        }
    }
}

