/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.eventlisteners;

import com.eidng3lz.mininginplace.Config;
import com.eidng3lz.mininginplace.MiningInPlace;
import com.eidng3lz.mininginplace.functions.dodropandmoveblock.DropAndMoveBlock;
import com.eidng3lz.mininginplace.functions.searchblocks.Bfs;
import com.eidng3lz.mininginplace.util.BlockGroup;
import com.eidng3lz.mininginplace.util.KeyValuePair;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="mininginplace")
public class OnBlockBreak {
    @SubscribeEvent
    public static void searchBlocksAndMoveBlock(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getLevel();
        BlockPos eventBlockPos = event.getPos();
        BlockState eventBlockState = event.getState();
        Player player = event.getPlayer();
        if (!player.getClass().equals(ServerPlayer.class)) {
            return;
        }
        BlockGroup blockGroup = new BlockGroup();
        for (BlockGroup configBlockGroup : Config.chainedBlocksGroups) {
            if (!configBlockGroup.contains(eventBlockState.getBlock())) continue;
            blockGroup.addBlockGroup(configBlockGroup);
        }
        Map<Config.ClientConfigs, Object> clientConfigsMap = MiningInPlace.playerConfigs.get(player.getName().getString());
        if (!(blockGroup.isEmpty() || player.isShiftKeyDown() != ((Boolean)clientConfigsMap.get((Object)Config.ClientConfigs.INVENT_CONTROL)).booleanValue() || ((Boolean)clientConfigsMap.get((Object)Config.ClientConfigs.DISABLE_AT_CREATIVE)).booleanValue() && player.isCreative())) {
            event.setCanceled(true);
            Bfs searcher = new Bfs();
            List<KeyValuePair<BlockPos, Integer>> searchResultsList = searcher.search(world, eventBlockPos, blockGroup, Config.depthLimit, Config.searchStepsLimit);
            BlockPos targetBlockPos = searchResultsList.getLast().getKey();
            DropAndMoveBlock.run(world, (ServerPlayer)player, eventBlockPos, targetBlockPos);
        }
    }
}

