/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.functions.aabb;

import net.minecraft.world.phys.Vec3;

public class Intersection {
    public static int getRayIntersectSurfaceNoCheck(Vec3 startPos, Vec3 direction, Vec3 aabbMinPos) {
        double[] startPosArr = new double[]{startPos.x(), startPos.y(), startPos.z()};
        double[] directionArr = new double[]{direction.x(), direction.y(), direction.z()};
        double[] aabbMinPosArr = new double[]{aabbMinPos.x(), aabbMinPos.y(), aabbMinPos.z()};
        double[] aabbMaxPosArr = new double[]{aabbMinPos.x() + 1.0, aabbMinPos.y() + 1.0, aabbMinPos.z() + 1.0};
        double tNear = Double.NEGATIVE_INFINITY;
        int surfaceIndex = -1;
        for (int i = 0; i < 3; ++i) {
            double tMin;
            int intersectIn;
            if (directionArr[i] == 0.0) continue;
            double invDir = 1.0 / directionArr[i];
            double t1 = (aabbMinPosArr[i] - startPosArr[i]) * invDir;
            double t2 = (aabbMaxPosArr[i] - startPosArr[i]) * invDir;
            if (t1 < t2) {
                intersectIn = -1;
                tMin = t1;
            } else {
                intersectIn = 1;
                tMin = t2;
            }
            if (!(tMin > tNear)) continue;
            tNear = tMin;
            surfaceIndex = intersectIn == -1 ? i : i + 3;
        }
        return surfaceIndex;
    }
}

