/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.functions.dodropandmoveblock;

import com.eidng3lz.mininginplace.MiningInPlace;
import com.eidng3lz.mininginplace.functions.aabb.Intersection;
import com.eidng3lz.mininginplace.network.Packets;
import com.eidng3lz.mininginplace.network.misc.RequestPacketArgs;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class DropAndMoveBlock {
    private static final double ITEM_ENTITY_Y_POS_OFFSET = (double)EntityType.ITEM.getHeight() / 2.0;

    public static void run(LevelAccessor world, ServerPlayer player, BlockPos destroyPos, BlockPos moveFromPos) {
        double BLOCK_SIZE = 1.0;
        double FORCE = 0.1;
        BlockState destroyBlockState = world.getBlockState(destroyPos);
        Block destroyBlock = destroyBlockState.getBlock();
        if (destroyBlock instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
            ((ServerLevel)world).sendBlockUpdated(destroyPos, destroyBlockState, destroyBlockState, 0);
            return;
        }
        if (player.blockActionRestricted((Level)world, destroyPos, player.gameMode.getGameModeForPlayer())) {
            return;
        }
        destroyBlockState = destroyBlock.playerWillDestroy((Level)world, destroyPos, destroyBlockState, (Player)player);
        String args = MiningInPlace.gson.toJson((Object)new RequestPacketArgs.BlockDestroyEffectArgs(new int[]{destroyPos.getX(), destroyPos.getY(), destroyPos.getZ()}, Block.getId((BlockState)destroyBlockState)));
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new Packets.RequestPacket("play-block-destroy-effect", args), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (player.isCreative()) {
            world.setBlock(destroyPos, world.getBlockState(moveFromPos), 3);
            world.destroyBlock(moveFromPos, false);
            return;
        }
        world.setBlock(destroyPos, world.getBlockState(moveFromPos), 3);
        world.destroyBlock(moveFromPos, false);
        ItemStack itemStack = player.getMainHandItem();
        ItemStack itemStackOld = itemStack.copy();
        itemStack.mineBlock((Level)world, destroyBlockState, destroyPos, (Player)player);
        if (itemStack.isEmpty() && !itemStackOld.isEmpty()) {
            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)itemStackOld, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        if (destroyBlockState.canHarvestBlock((BlockGetter)world, destroyPos, (Player)player)) {
            int dropsSpawnSurface = Intersection.getRayIntersectSurfaceNoCheck(player.getEyePosition(), player.getViewVector(1.0f), new Vec3((double)destroyPos.getX(), (double)destroyPos.getY(), (double)destroyPos.getZ()));
            double offset = (1.0 + (double)EntityType.ITEM.getHeight()) / 2.0;
            Vec3 dropsSpawnPos = switch (dropsSpawnSurface) {
                case 0 -> destroyPos.getCenter().add(-offset, 0.0, 0.0);
                case 1 -> destroyPos.getCenter().add(0.0, -offset, 0.0);
                case 2 -> destroyPos.getCenter().add(0.0, 0.0, -offset);
                case 3 -> destroyPos.getCenter().add(offset, 0.0, 0.0);
                case 4 -> destroyPos.getCenter().add(0.0, offset, 0.0);
                case 5 -> destroyPos.getCenter().add(0.0, 0.0, offset);
                default -> destroyPos.getCenter();
            };
            Vec3 pushVec = dropsSpawnPos.vectorTo(player.getEyePosition()).scale(0.1);
            DropAndMoveBlock.dropAndSpawn((ServerLevel)world, destroyBlockState, destroyPos, (Entity)player, itemStackOld, dropsSpawnPos, pushVec);
            player.awardStat(Stats.BLOCK_MINED.get((Object)destroyBlock));
            player.causeFoodExhaustion(0.005f);
        }
    }

    private static void dropAndSpawn(ServerLevel world, BlockState blockState, BlockPos blockPos, Entity destroyer, ItemStack toolItemStack, Vec3 dropsSpawnPos, Vec3 pushVec) {
        List<Object> dropsItemEntityList;
        boolean shouldDrop = world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !world.restoringBlockSnapshots;
        BlockPos spawnBlockPos = new BlockPos((int)Math.floor(dropsSpawnPos.x()), (int)Math.floor(dropsSpawnPos.y()), (int)Math.floor(dropsSpawnPos.z()));
        if (shouldDrop) {
            List dropItemStack = Block.getDrops((BlockState)blockState, (ServerLevel)world, (BlockPos)blockPos, null, (Entity)destroyer, (ItemStack)toolItemStack);
            dropsItemEntityList = dropItemStack.stream().filter(itemStack -> !itemStack.isEmpty()).map(itemStack -> {
                double x = dropsSpawnPos.x();
                double y = dropsSpawnPos.y() - ITEM_ENTITY_Y_POS_OFFSET;
                double z = dropsSpawnPos.z();
                ItemEntity itemEntity = new ItemEntity((Level)world, x, y, z, itemStack, world.random.nextDouble() * 0.2 - 0.1, 0.1, world.random.nextDouble() * 0.2 - 0.1);
                itemEntity.setDefaultPickUpDelay();
                itemEntity.push(pushVec);
                return itemEntity;
            }).collect(Collectors.toList());
        } else {
            dropsItemEntityList = new ArrayList();
        }
        BlockDropsEvent event = new BlockDropsEvent(world, blockPos, blockState, null, dropsItemEntityList, destroyer, toolItemStack);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        event.getDrops().forEach(arg_0 -> ((ServerLevel)world).addFreshEntity(arg_0));
        int droppedExperience = event.getDroppedExperience();
        if (droppedExperience > 0 && shouldDrop) {
            ExperienceOrb.award((ServerLevel)world, (Vec3)dropsSpawnPos, (int)droppedExperience);
        }
        blockState.spawnAfterBreak(world, spawnBlockPos, toolItemStack, false);
    }
}

