/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.functions.searchblocks;

import com.eidng3lz.mininginplace.functions.searchblocks.BlockSearcher;
import com.eidng3lz.mininginplace.util.BlockGroup;
import com.eidng3lz.mininginplace.util.KeyValuePair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;

public class Bfs
implements BlockSearcher {
    private static final int[][] CONNECTED_BLOCK_RELATIVE_POS = new int[][]{{-1, -1, -1}, {0, -1, -1}, {1, -1, -1}, {-1, 0, -1}, {0, 0, -1}, {1, 0, -1}, {-1, 1, -1}, {0, 1, -1}, {1, 1, -1}, {-1, -1, 0}, {0, -1, 0}, {1, -1, 0}, {-1, 0, 0}, {1, 0, 0}, {-1, 1, 0}, {0, 1, 0}, {1, 1, 0}, {-1, -1, 1}, {0, -1, 1}, {1, -1, 1}, {-1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {-1, 1, 1}, {0, 1, 1}, {1, 1, 1}};

    @Override
    public List<KeyValuePair<BlockPos, Integer>> search(LevelAccessor world, BlockPos startPos, BlockGroup targetBlockGroup, int depthLimit, int searchStepsLimit) {
        HashSet<BlockPos> searchedPos = new HashSet<BlockPos>();
        ArrayList<KeyValuePair<BlockPos, Integer>> resultList = new ArrayList<KeyValuePair<BlockPos, Integer>>();
        ArrayList<BlockPos> searchingList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> nextSearchList = new ArrayList<BlockPos>();
        searchingList.add(startPos);
        searchedPos.add(startPos);
        block0: for (int depth = 0; !searchingList.isEmpty() && depth <= depthLimit; ++depth) {
            for (BlockPos searchingPos : searchingList) {
                resultList.add(new KeyValuePair<BlockPos, Integer>(searchingPos, depth));
                if (resultList.size() >= searchStepsLimit) break block0;
                for (int[] offset : CONNECTED_BLOCK_RELATIVE_POS) {
                    BlockPos nextLayerPos = new BlockPos(searchingPos.getX() + offset[0], searchingPos.getY() + offset[1], searchingPos.getZ() + offset[2]);
                    if (!targetBlockGroup.contains(world.getBlockState(nextLayerPos).getBlock()) || searchedPos.contains(nextLayerPos)) continue;
                    nextSearchList.add(nextLayerPos);
                    searchedPos.add(nextLayerPos);
                }
            }
            searchingList.clear();
            ArrayList<BlockPos> temp = searchingList;
            searchingList = nextSearchList;
            nextSearchList = temp;
        }
        return resultList;
    }
}

