/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.network;

import com.eidng3lz.mininginplace.Config;
import com.eidng3lz.mininginplace.MiningInPlace;
import com.eidng3lz.mininginplace.network.misc.RequestPacketArgs;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class Packets {

    public record RequestPacket(String request, String args) implements CustomPacketPayload
    {
        public static final String GET_CLIENT_CONFIGS = "get-client-configs";
        public static final String SET_CLIENT_CONFIGS = "set-client-configs";
        public static final String SET_SERVER_CONFIGS = "set-server-configs";
        public static final String PLAY_BLOCK_DESTROY_EFFECT = "play-block-destroy-effect";
        public static final CustomPacketPayload.Type<RequestPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mininginplace", (String)"request_packet"));
        public static final StreamCodec<ByteBuf, RequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, RequestPacket::request, (StreamCodec)ByteBufCodecs.STRING_UTF8, RequestPacket::args, RequestPacket::new);

        public static void onClientHandleDate(RequestPacket packet, IPayloadContext context) {
            switch (packet.request()) {
                case "get-client-configs": {
                    PacketDistributor.sendToServer((CustomPacketPayload)new RequestPacket(SET_CLIENT_CONFIGS, Config.getClientConfigsToJSON()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                case "set-client-configs": {
                    LogUtils.getLogger().info("client side not supported");
                    break;
                }
                case "set-server-configs": {
                    Map map = (Map)MiningInPlace.gson.fromJson(packet.args(), (TypeToken)new TypeToken<Map<Config.ServerConfigs, Object>>(){});
                    MiningInPlace.serverConfigs.clear();
                    MiningInPlace.serverConfigs.putAll(map);
                    Config.ServerConfigs key = Config.ServerConfigs.CHAINED_BLOCKS_GROUPS;
                    MiningInPlace.serverConfigs.put(key, Config.decodeChainedBlocksGroups((List)map.get((Object)key)));
                    break;
                }
                case "play-block-destroy-effect": {
                    Level level = context.player().level();
                    RequestPacketArgs.BlockDestroyEffectArgs blockDestroyEffectArgs = (RequestPacketArgs.BlockDestroyEffectArgs)MiningInPlace.gson.fromJson(packet.args(), RequestPacketArgs.BlockDestroyEffectArgs.class);
                    BlockPos pos = new BlockPos(blockDestroyEffectArgs.pos()[0], blockDestroyEffectArgs.pos()[1], blockDestroyEffectArgs.pos()[2]);
                    level.levelEvent(2001, pos, blockDestroyEffectArgs.blockId());
                    break;
                }
            }
        }

        public static void onServerHandleDate(RequestPacket packet, IPayloadContext context) {
            switch (packet.request()) {
                case "get-client-configs": {
                    LogUtils.getLogger().info("server side not supported");
                    break;
                }
                case "set-client-configs": {
                    Map map = (Map)MiningInPlace.gson.fromJson(packet.args(), (TypeToken)new TypeToken<Map<Config.ClientConfigs, Object>>(){});
                    MiningInPlace.playerConfigs.put(context.player().getName().getString(), map);
                    break;
                }
                case "set-server-configs": {
                    LogUtils.getLogger().info("server side not supported");
                    break;
                }
                case "play-block-destroy-effect": {
                    LogUtils.getLogger().info("server side not supported");
                    break;
                }
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

