/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace;

import com.eidng3lz.mininginplace.network.ConfigPayload;
import com.eidng3lz.mininginplace.utils.BlockGroup;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="mininginplace", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue INVENT_CONTROL = BUILDER.comment(new String[]{"\u53cd\u8f6c\u6f5c\u884c\u8fde\u9501\u63a7\u5236", "\u9ed8\u8ba4\u6f5c\u884c\u65f6\u505c\u6b62\u8fde\u9501"}).translation("mininginplace.config.invent_control").define("invent_control", false);
    private static final ModConfigSpec.IntValue DEPTH_LIMIT = BUILDER.comment(new String[]{"\u6700\u5927\u641c\u7d22\u6df1\u5ea6", "\u8bf7\u52ff\u8bbe\u7f6e\u8fc7\u5927\u7684\u6570\u503c\uff0c\u4ee5\u514d\u53ef\u80fd\u51fa\u73b0\u7684\u6027\u80fd\u95ee\u9898\u3002"}).translation("mininginplace.config.depth_limit").defineInRange("depth_limit", 64, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue SEARCH_STEPS_LIMIT = BUILDER.comment(new String[]{"\u6700\u5927\u641c\u7d22\u6b65\u6570", "\u8bf7\u52ff\u8bbe\u7f6e\u8fc7\u5927\u7684\u6570\u503c\uff0c\u4ee5\u514d\u53ef\u80fd\u51fa\u73b0\u7684\u6027\u80fd\u95ee\u9898\u3002"}).translation("mininginplace.config.search_steps_limit").defineInRange("search_steps_limit", 128, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> CHAINLAND_BLOCKS_GROUPS = BUILDER.comment(new String[]{"\u8fde\u9501\u65b9\u5757\u7ec4", "\u6bcf\u4e2a\u5b57\u7b26\u4e32\u4e3a\u4e00\u7ec4\uff0c\u7ec4\u5185\u7684\u591a\u4e2aID\u6216Tag\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694\uff0cTag\u9700\u8981\u4ee5#\u5f00\u5934\u3002", "\u547d\u540d\u7a7a\u95f4\u4e3aminecraft\u65f6\u53ef\u7701\u7565\u3002"}).translation("mininginplace.config.blocks_groups").defineListAllowEmpty("chainland_blocks_groups", List.of("minecraft:oak_log", "minecraft:spruce_log", "minecraft:birch_log", "minecraft:jungle_log", "minecraft:acacia_log", "minecraft:dark_oak_log", "minecraft:mangrove_log", "minecraft:cherry_log", "minecraft:pale_oak_log", "minecraft:crimson_stem", "minecraft:warped_stem", "minecraft:coal_ore,minecraft:deepslate_coal_ore", "minecraft:iron_ore,minecraft:deepslate_iron_ore,minecraft:raw_iron_block", "minecraft:copper_ore,minecraft:deepslate_copper_ore,minecraft:raw_copper_block", "minecraft:gold_ore,minecraft:deepslate_gold_ore", "minecraft:redstone_ore,minecraft:deepslate_redstone_ore", "minecraft:emerald_ore,minecraft:deepslate_emerald_ore", "minecraft:lapis_ore,minecraft:deepslate_lapis_ore", "minecraft:diamond_ore,minecraft:deepslate_diamond_ore", "minecraft:nether_gold_ore", "minecraft:nether_quartz_ore", "minecraft:ancient_debris", "minecraft:glowstone"), () -> "", Config::validateBlockGroups);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean inventControl;
    public static int depthLimit;
    public static int searchStepsLimit;
    public static List<BlockGroup> chainlandBlocksGroups;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        inventControl = (Boolean)INVENT_CONTROL.get();
        depthLimit = (Integer)DEPTH_LIMIT.get();
        searchStepsLimit = (Integer)SEARCH_STEPS_LIMIT.get();
        chainlandBlocksGroups = new ArrayList<BlockGroup>();
        for (String group : (List)CHAINLAND_BLOCKS_GROUPS.get()) {
            ArrayList<String> blockIDOrTagList = new ArrayList<String>();
            String[] splitGroup = group.split(",");
            BlockGroup blockGroup = new BlockGroup();
            for (String s : splitGroup) {
                String blockIDOrTag = s.trim();
                if (blockIDOrTag.isEmpty()) continue;
                blockIDOrTagList.add(blockIDOrTag);
            }
            for (String s : blockIDOrTagList) {
                blockGroup.addFromStr(s);
            }
            chainlandBlocksGroups.add(blockGroup);
        }
        try {
            PacketDistributor.sendToServer((CustomPacketPayload)new ConfigPayload(inventControl), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (Exception e) {
            LogUtils.getLogger().info(e.getMessage());
        }
    }

    private static boolean validateBlockGroups(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String group = (String)obj;
        for (String blockIDOrTag : group.split(",")) {
            if ((blockIDOrTag = blockIDOrTag.trim()).isEmpty()) continue;
            if (blockIDOrTag.charAt(0) == '#') {
                if (blockIDOrTag.matches("^#([a-zA-Z0-9._-]+:)?[a-zA-Z0-9._-]+(/?[a-zA-Z0-9._-]+)*$")) continue;
                return false;
            }
            try {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)blockIDOrTag);
                if (BuiltInRegistries.BLOCK.containsKey(resourceLocation)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

