/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.eventlisteners;

import com.eidng3lz.mininginplace.Config;
import com.eidng3lz.mininginplace.MiningInPlace;
import com.eidng3lz.mininginplace.utils.BlockGroup;
import com.eidng3lz.mininginplace.utils.Dfs;
import com.eidng3lz.mininginplace.utils.KeyValuePair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="mininginplace")
public class OnBlockBreak {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getLevel();
        BlockPos eventBlockPos = event.getPos();
        BlockState eventBlockState = event.getState();
        Player player = event.getPlayer();
        if (!player.getClass().getSimpleName().equals("ServerPlayer")) {
            return;
        }
        BlockGroup blockGroup = new BlockGroup();
        for (BlockGroup configBlockGroup : Config.chainlandBlocksGroups) {
            if (!configBlockGroup.contains(eventBlockState.getBlock())) continue;
            blockGroup.addBlockGroup(configBlockGroup);
        }
        if (!blockGroup.isEmpty() && player.isShiftKeyDown() == MiningInPlace.playerConfigs.get(player.getName().getString()).booleanValue()) {
            Dfs dfs = new Dfs();
            List<KeyValuePair<BlockPos, Integer>> dfsResultsList = dfs.dfs(world, eventBlockPos, blockGroup, Config.depthLimit, Config.searchStepsLimit);
            KeyValuePair<BlockPos, Integer> deepest = dfsResultsList.getFirst();
            for (KeyValuePair<BlockPos, Integer> keyValuePair : dfsResultsList) {
                if (keyValuePair.getValue() == Config.depthLimit) {
                    deepest = keyValuePair;
                    break;
                }
                if (keyValuePair.getValue() <= deepest.getValue()) continue;
                deepest = keyValuePair;
            }
            BlockPos targetBlockPos = deepest.getKey();
            MiningInPlace.queueServerWork(1, new MoveBlock(world, targetBlockPos, eventBlockPos));
            MiningInPlace.blockBreakEventFlag.put(player.toString(), 0);
        }
    }

    private static class MoveBlock
    implements Runnable {
        LevelAccessor world;
        BlockPos fromPos;
        BlockPos toPos;

        public MoveBlock(LevelAccessor world, BlockPos fromPos, BlockPos toPos) {
            this.world = world;
            this.fromPos = fromPos;
            this.toPos = toPos;
        }

        @Override
        public void run() {
            this.world.setBlock(this.toPos, this.world.getBlockState(this.fromPos), 3);
            this.world.destroyBlock(this.fromPos, false);
        }
    }
}

