/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.eventlisteners;

import com.eidng3lz.mininginplace.MiningInPlace;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="mininginplace")
public class OnBlockDrops {
    @SubscribeEvent
    public static void onBlockDrops(BlockDropsEvent event) {
        double FORCE = 0.1;
        double BLOCK_SIZE = 1.0;
        double ITEM_ENTITY_SIZE = 0.25;
        Vec3 ITEM_INITIAL_VELOCITY = new Vec3(0.0, 0.3, 0.0);
        Vec3 PLAYER_CAMERA_POS_OFFSET = new Vec3(0.0, 1.5, 0.0);
        Entity breakerEntity = event.getBreaker();
        List dropItemEntityList = event.getDrops();
        BlockPos eventPos = event.getPos();
        if (breakerEntity != null && MiningInPlace.blockBreakEventFlag.containsKey(breakerEntity.toString())) {
            Vec3 relativelyVec = eventPos.getCenter().vectorTo(breakerEntity.position().add(PLAYER_CAMERA_POS_OFFSET));
            Vec3 offsetVec = OnBlockDrops.getOffsetVec(relativelyVec, 1.0, 0.25);
            Vec3 moveToVec = eventPos.getCenter().add(offsetVec).add(0.0, -0.125, 0.0);
            Vec3 pushVec = moveToVec.vectorTo(breakerEntity.position()).multiply(0.1, 0.1, 0.1);
            for (ItemEntity item : dropItemEntityList) {
                item.setDeltaMovement(ITEM_INITIAL_VELOCITY);
                item.setPos(moveToVec);
                item.push(pushVec);
            }
            MiningInPlace.blockBreakEventFlag.remove(breakerEntity.toString());
        }
    }

    @NotNull
    private static Vec3 getOffsetVec(Vec3 relativelyVec, double BLOCK_SIZE, double ITEM_ENTITY_SIZE) {
        double max = Math.max(Math.max(Math.abs(relativelyVec.x()), Math.abs(relativelyVec.y())), Math.abs(relativelyVec.z()));
        double zoomMultiplier = (BLOCK_SIZE + ITEM_ENTITY_SIZE) / 2.0 / max;
        return relativelyVec.multiply(zoomMultiplier, zoomMultiplier, zoomMultiplier);
    }
}

