/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.utils;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class BlockGroup {
    private Set<Block> blockSet = new HashSet<Block>();
    private Set<TagKey<Block>> tagKeySet = new HashSet<TagKey<Block>>();

    public boolean addFromStr(String blockIDOrTag) {
        Block block;
        if (blockIDOrTag.charAt(0) == '#') {
            TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)blockIDOrTag.substring(1)));
            return this.tagKeySet.add((TagKey<Block>)tagKey);
        }
        Class clazz = BuiltInRegistries.BLOCK.getClass();
        try {
            try {
                Method methodNew = clazz.getMethod("getValue", ResourceLocation.class);
                block = (Block)methodNew.invoke((Object)BuiltInRegistries.BLOCK, ResourceLocation.tryParse((String)blockIDOrTag));
            }
            catch (NoSuchMethodException e) {
                Method methodOld = clazz.getMethod("get", ResourceLocation.class);
                block = (Block)methodOld.invoke((Object)BuiltInRegistries.BLOCK, ResourceLocation.tryParse((String)blockIDOrTag));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.blockSet.add(block);
    }

    public boolean add(Block block) {
        return this.blockSet.add(block);
    }

    public boolean add(TagKey<Block> tagKey) {
        return this.tagKeySet.add(tagKey);
    }

    public boolean contains(Block block) {
        if (this.blockSet.contains(block)) {
            return true;
        }
        for (TagKey<Block> tagKey : this.tagKeySet) {
            if (!block.defaultBlockState().is(tagKey)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.blockSet.isEmpty() && this.tagKeySet.isEmpty();
    }

    public boolean addBlockGroup(BlockGroup blockGroup) {
        boolean a = this.blockSet.addAll(blockGroup.getBlockSet());
        boolean b = this.tagKeySet.addAll(blockGroup.getTagKeySet());
        return a || b;
    }

    public Set<Block> getBlockSet() {
        return this.blockSet;
    }

    public Set<TagKey<Block>> getTagKeySet() {
        return this.tagKeySet;
    }
}

