/*
 * Decompiled with CFR 0.152.
 */
package com.eidng3lz.mininginplace.utils;

import com.eidng3lz.mininginplace.utils.BlockGroup;
import com.eidng3lz.mininginplace.utils.KeyValuePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;

public class Dfs {
    private static final int[][] CONNECTED_BLOCK_RELATIVE_POS = new int[][]{{-1, -1, -1}, {0, -1, -1}, {1, -1, -1}, {-1, 0, -1}, {0, 0, -1}, {1, 0, -1}, {-1, 1, -1}, {0, 1, -1}, {1, 1, -1}, {-1, -1, 0}, {0, -1, 0}, {1, -1, 0}, {-1, 0, 0}, {1, 0, 0}, {-1, 1, 0}, {0, 1, 0}, {1, 1, 0}, {-1, -1, 1}, {0, -1, 1}, {1, -1, 1}, {-1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {-1, 1, 1}, {0, 1, 1}, {1, 1, 1}};
    private List<KeyValuePair<BlockPos, Integer>> searchedPosList = new ArrayList<KeyValuePair<BlockPos, Integer>>();

    private boolean containsPos(BlockPos pos) {
        for (KeyValuePair<BlockPos, Integer> keyValuePair : this.searchedPosList) {
            if (!keyValuePair.getKey().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public List<KeyValuePair<BlockPos, Integer>> dfs(LevelAccessor world, BlockPos startPos, BlockGroup blockGroup, int depthLimit, int searchStepsLimit) {
        Stack<SearchNode> searchNodeStack = new Stack<SearchNode>();
        searchNodeStack.push(new SearchNode(this, startPos, 0));
        while (!searchNodeStack.isEmpty() && this.searchedPosList.size() <= searchStepsLimit) {
            SearchNode currentNode = (SearchNode)searchNodeStack.pop();
            BlockPos pos = currentNode.pos;
            int depth = currentNode.depth;
            this.searchedPosList.add(new KeyValuePair<BlockPos, Integer>(pos, depth));
            if (depth + 1 > depthLimit) continue;
            for (int[] offset : CONNECTED_BLOCK_RELATIVE_POS) {
                BlockPos newPos = new BlockPos(pos.getX() + offset[0], pos.getY() + offset[1], pos.getZ() + offset[2]);
                if (!blockGroup.contains(world.getBlockState(newPos).getBlock()) || this.containsPos(newPos)) continue;
                searchNodeStack.push(new SearchNode(this, newPos, depth + 1));
            }
        }
        return this.searchedPosList;
    }

    private class SearchNode {
        BlockPos pos;
        int depth;

        SearchNode(Dfs dfs, BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }
    }
}

