/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.playerdata.PlayerGotNote;
import mcjty.theoneprobe.playerdata.PlayerProperties;
import mcjty.theoneprobe.playerdata.PropertiesDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        Config.setupStyleConfig(Config.mainConfig);
        Config.updateDefaultOverlayStyle();
        if (Config.mainConfig.hasChanged()) {
            Config.mainConfig.save();
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !((Entity)event.getObject()).hasCapability(PlayerProperties.PLAYER_GOT_NOTE, null)) {
            event.addCapability(new ResourceLocation("theoneprobe", "Properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasCapability(PlayerProperties.PLAYER_GOT_NOTE, null)) {
            PlayerGotNote oldStore = (PlayerGotNote)event.getOriginal().getCapability(PlayerProperties.PLAYER_GOT_NOTE, null);
            PlayerGotNote newStore = PlayerProperties.getPlayerGotNote(event.getEntityPlayer());
            assert (oldStore != null);
            newStore.copyFrom(oldStore);
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean success;
        PlayerGotNote note;
        if (Config.spawnNote && !(note = PlayerProperties.getPlayerGotNote(event.player)).isPlayerGotNote() && (success = event.player.inventory.addItemStackToInventory(new ItemStack((Item)ModItems.probeNote)))) {
            note.setPlayerGotNote(true);
        }
    }
}

