/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ElementEntityRender {
    private static final EntityId FIXER = new EntityId();

    public static void renderPlayer(String entityName, Integer playerID, IEntityStyle style, int x, int y) {
        Entity entity = ClientTools.mc.world.getEntityByID(playerID.intValue());
        if (entity != null) {
            ElementEntityRender.renderEntity(style, x, y, entity);
        }
    }

    public static void render(String entityName, NBTTagCompound entityNBT, IEntityStyle style, int x, int y) {
        if (entityName != null && !entityName.isEmpty()) {
            Entity entity = null;
            if (entityNBT != null) {
                entity = EntityList.createEntityFromNBT((NBTTagCompound)entityNBT, (World)ClientTools.mc.world);
            } else {
                String fixed = ElementEntityRender.fixEntityId(entityName);
                EntityEntry value = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(fixed));
                if (value != null) {
                    entity = value.newInstance((World)ClientTools.mc.world);
                }
            }
            if (entity != null) {
                ElementEntityRender.renderEntity(style, x, y, entity);
            }
        }
    }

    public static String fixEntityId(String id) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setString("id", id);
        nbt = FIXER.fixTagCompound(nbt);
        return nbt.getString("id");
    }

    private static void renderEntity(IEntityStyle style, int x, int y, Entity entity) {
        float height = entity.height;
        height = (float)((double)(height - 1.0f) * 0.7 + 1.0);
        float s = style.getScale() * ((float)style.getHeight() * 14.0f / 25.0f / height);
        RenderHelper.renderEntity(entity, x, y, s);
    }
}

