/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import mcjty.theoneprobe.ClientTools;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ElementProgressGradientRender
extends ElementProgressRender {
    public static void render(IProgressStyle style, long current, long max, int x, int y, int w, int h) {
        if (style.isLifeBar()) {
            ElementProgressGradientRender.renderLifeBar(current, x, y, w, h);
        } else if (style.isArmorBar()) {
            ElementProgressGradientRender.renderArmorBar(current, x, y, w, h);
        } else {
            int dx;
            RenderHelper.drawThickBeveledBox(x, y, x + w, y + h, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
            if (current > 0L && max > 0L && (dx = (int)Math.min(current * (long)(w - 2) / max, (long)(w - 2))) > 0) {
                ElementProgressGradientRender.drawGradientBar(x + 1, y + 1, x + dx + 1, y + h - 1, style.getAlternatefilledColor(), style.getFilledColor());
            }
        }
        if (style.isShowText()) {
            RenderHelper.renderText(ClientTools.mc, x + 3, y + 2, style.getPrefix() + ElementProgress.format(current, style.getNumberFormat(), style.getSuffix()));
        }
    }

    private static void drawGradientBar(int startX, int startY, int endX, int endY, int startColor, int endColor) {
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        buffer.pos((double)startX, (double)endY, 0.0).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        buffer.pos((double)endX, (double)endY, 0.0).color(endRed, endGreen, endBlue, endAlpha).endVertex();
        buffer.pos((double)endX, (double)startY, 0.0).color(endRed, endGreen, endBlue, endAlpha).endVertex();
        buffer.pos((double)startX, (double)startY, 0.0).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        tessellator.draw();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableTexture2D();
    }
}

